/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.ServiceNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceId
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceId> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ServiceId.getter(ServiceId::name)).setter(ServiceId.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Names").getter(ServiceId.getter(ServiceId::names)).setter(ServiceId.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ServiceId.getter(ServiceId::accountId)).setter(ServiceId.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ServiceId.getter(ServiceId::type)).setter(ServiceId.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NAMES_FIELD, ACCOUNT_ID_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceId.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> names;
    private final String accountId;
    private final String type;

    private ServiceId(BuilderImpl builder) {
        this.name = builder.name;
        this.names = builder.names;
        this.accountId = builder.accountId;
        this.type = builder.type;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public final List<String> names() {
        return this.names;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNames() ? this.names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceId)) {
            return false;
        }
        ServiceId other = (ServiceId)obj;
        return Objects.equals(this.name(), other.name()) && this.hasNames() == other.hasNames() && Objects.equals(this.names(), other.names()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceId").add("Name", (Object)this.name()).add("Names", this.hasNames() ? this.names() : null).add("AccountId", (Object)this.accountId()).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Names", NAMES_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceId, T> g) {
        return obj -> g.apply((ServiceId)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> names = DefaultSdkAutoConstructList.getInstance();
        private String accountId;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceId model) {
            this.name(model.name);
            this.names(model.names);
            this.accountId(model.accountId);
            this.type(model.type);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getNames() {
            if (this.names instanceof SdkAutoConstructList) {
                return null;
            }
            return this.names;
        }

        public final void setNames(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public ServiceId build() {
            return new ServiceId(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceId> {
        public Builder name(String var1);

        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder accountId(String var1);

        public Builder type(String var1);
    }
}

