/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.SamplingStatisticsDocument;
import software.amazon.awssdk.services.xray.model.SamplingStatisticsDocumentListCopier;
import software.amazon.awssdk.services.xray.model.XRayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSamplingTargetsRequest
extends XRayRequest
implements ToCopyableBuilder<Builder, GetSamplingTargetsRequest> {
    private static final SdkField<List<SamplingStatisticsDocument>> SAMPLING_STATISTICS_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SamplingStatisticsDocuments").getter(GetSamplingTargetsRequest.getter(GetSamplingTargetsRequest::samplingStatisticsDocuments)).setter(GetSamplingTargetsRequest.setter(Builder::samplingStatisticsDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingStatisticsDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SamplingStatisticsDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLING_STATISTICS_DOCUMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSamplingTargetsRequest.memberNameToFieldInitializer();
    private final List<SamplingStatisticsDocument> samplingStatisticsDocuments;

    private GetSamplingTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.samplingStatisticsDocuments = builder.samplingStatisticsDocuments;
    }

    public final boolean hasSamplingStatisticsDocuments() {
        return this.samplingStatisticsDocuments != null && !(this.samplingStatisticsDocuments instanceof SdkAutoConstructList);
    }

    public final List<SamplingStatisticsDocument> samplingStatisticsDocuments() {
        return this.samplingStatisticsDocuments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSamplingStatisticsDocuments() ? this.samplingStatisticsDocuments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSamplingTargetsRequest)) {
            return false;
        }
        GetSamplingTargetsRequest other = (GetSamplingTargetsRequest)((Object)obj);
        return this.hasSamplingStatisticsDocuments() == other.hasSamplingStatisticsDocuments() && Objects.equals(this.samplingStatisticsDocuments(), other.samplingStatisticsDocuments());
    }

    public final String toString() {
        return ToString.builder((String)"GetSamplingTargetsRequest").add("SamplingStatisticsDocuments", this.hasSamplingStatisticsDocuments() ? this.samplingStatisticsDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SamplingStatisticsDocuments": {
                return Optional.ofNullable(clazz.cast(this.samplingStatisticsDocuments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<SamplingStatisticsDocument>>> map = new HashMap<String, SdkField<List<SamplingStatisticsDocument>>>();
        map.put("SamplingStatisticsDocuments", SAMPLING_STATISTICS_DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSamplingTargetsRequest, T> g) {
        return obj -> g.apply((GetSamplingTargetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayRequest.BuilderImpl
    implements Builder {
        private List<SamplingStatisticsDocument> samplingStatisticsDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSamplingTargetsRequest model) {
            super(model);
            this.samplingStatisticsDocuments(model.samplingStatisticsDocuments);
        }

        public final List<SamplingStatisticsDocument.Builder> getSamplingStatisticsDocuments() {
            List<SamplingStatisticsDocument.Builder> result = SamplingStatisticsDocumentListCopier.copyToBuilder(this.samplingStatisticsDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSamplingStatisticsDocuments(Collection<SamplingStatisticsDocument.BuilderImpl> samplingStatisticsDocuments) {
            this.samplingStatisticsDocuments = SamplingStatisticsDocumentListCopier.copyFromBuilder(samplingStatisticsDocuments);
        }

        @Override
        public final Builder samplingStatisticsDocuments(Collection<SamplingStatisticsDocument> samplingStatisticsDocuments) {
            this.samplingStatisticsDocuments = SamplingStatisticsDocumentListCopier.copy(samplingStatisticsDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samplingStatisticsDocuments(SamplingStatisticsDocument ... samplingStatisticsDocuments) {
            this.samplingStatisticsDocuments(Arrays.asList(samplingStatisticsDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samplingStatisticsDocuments(Consumer<SamplingStatisticsDocument.Builder> ... samplingStatisticsDocuments) {
            this.samplingStatisticsDocuments(Stream.of(samplingStatisticsDocuments).map(c -> (SamplingStatisticsDocument)((SamplingStatisticsDocument.Builder)SamplingStatisticsDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSamplingTargetsRequest build() {
            return new GetSamplingTargetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends XRayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSamplingTargetsRequest> {
        public Builder samplingStatisticsDocuments(Collection<SamplingStatisticsDocument> var1);

        public Builder samplingStatisticsDocuments(SamplingStatisticsDocument ... var1);

        public Builder samplingStatisticsDocuments(Consumer<SamplingStatisticsDocument.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

