/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RetrievalStatus {
    SCHEDULED("SCHEDULED"),
    RUNNING("RUNNING"),
    COMPLETE("COMPLETE"),
    FAILED("FAILED"),
    CANCELLED("CANCELLED"),
    TIMEOUT("TIMEOUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RetrievalStatus> VALUE_MAP;
    private final String value;

    private RetrievalStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RetrievalStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RetrievalStatus> knownValues() {
        EnumSet<RetrievalStatus> knownValues = EnumSet.allOf(RetrievalStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RetrievalStatus.class, RetrievalStatus::toString);
    }
}

