/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TraceFormatType {
    XRAY("XRAY"),
    OTEL("OTEL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TraceFormatType> VALUE_MAP;
    private final String value;

    private TraceFormatType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TraceFormatType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TraceFormatType> knownValues() {
        EnumSet<TraceFormatType> knownValues = EnumSet.allOf(TraceFormatType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TraceFormatType.class, TraceFormatType::toString);
    }
}

