/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.xray.model.SamplingRule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SamplingRuleRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SamplingRuleRecord> {
    private static final SdkField<SamplingRule> SAMPLING_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SamplingRule").getter(SamplingRuleRecord.getter(SamplingRuleRecord::samplingRule)).setter(SamplingRuleRecord.setter(Builder::samplingRule)).constructor(SamplingRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingRule").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(SamplingRuleRecord.getter(SamplingRuleRecord::createdAt)).setter(SamplingRuleRecord.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAt").getter(SamplingRuleRecord.getter(SamplingRuleRecord::modifiedAt)).setter(SamplingRuleRecord.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLING_RULE_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SamplingRuleRecord.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SamplingRule samplingRule;
    private final Instant createdAt;
    private final Instant modifiedAt;

    private SamplingRuleRecord(BuilderImpl builder) {
        this.samplingRule = builder.samplingRule;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    public final SamplingRule samplingRule() {
        return this.samplingRule;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingRuleRecord)) {
            return false;
        }
        SamplingRuleRecord other = (SamplingRuleRecord)obj;
        return Objects.equals(this.samplingRule(), other.samplingRule()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt());
    }

    public final String toString() {
        return ToString.builder((String)"SamplingRuleRecord").add("SamplingRule", (Object)this.samplingRule()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SamplingRule": {
                return Optional.ofNullable(clazz.cast(this.samplingRule()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SamplingRule", SAMPLING_RULE_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ModifiedAt", MODIFIED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SamplingRuleRecord, T> g) {
        return obj -> g.apply((SamplingRuleRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SamplingRule samplingRule;
        private Instant createdAt;
        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingRuleRecord model) {
            this.samplingRule(model.samplingRule);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
        }

        public final SamplingRule.Builder getSamplingRule() {
            return this.samplingRule != null ? this.samplingRule.toBuilder() : null;
        }

        public final void setSamplingRule(SamplingRule.BuilderImpl samplingRule) {
            this.samplingRule = samplingRule != null ? samplingRule.build() : null;
        }

        @Override
        public final Builder samplingRule(SamplingRule samplingRule) {
            this.samplingRule = samplingRule;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public SamplingRuleRecord build() {
            return new SamplingRuleRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SamplingRuleRecord> {
        public Builder samplingRule(SamplingRule var1);

        default public Builder samplingRule(Consumer<SamplingRule.Builder> samplingRule) {
            return this.samplingRule((SamplingRule)((SamplingRule.Builder)SamplingRule.builder().applyMutation(samplingRule)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);
    }
}

