/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.xray.DefaultXRayAsyncClient;
import software.amazon.awssdk.services.xray.DefaultXRayBaseClientBuilder;
import software.amazon.awssdk.services.xray.XRayAsyncClient;
import software.amazon.awssdk.services.xray.XRayAsyncClientBuilder;
import software.amazon.awssdk.services.xray.XRayServiceClientConfiguration;
import software.amazon.awssdk.services.xray.endpoints.XRayEndpointProvider;

@SdkInternalApi
final class DefaultXRayAsyncClientBuilder
extends DefaultXRayBaseClientBuilder<XRayAsyncClientBuilder, XRayAsyncClient>
implements XRayAsyncClientBuilder {
    DefaultXRayAsyncClientBuilder() {
    }

    @Override
    public DefaultXRayAsyncClientBuilder endpointProvider(XRayEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final XRayAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultXRayAsyncClientBuilder.validateClientOptions(clientConfiguration);
        XRayServiceClientConfiguration serviceClientConfiguration = XRayServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultXRayAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

