/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.ServiceId;
import software.amazon.awssdk.services.xray.model.ServiceIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TraceUser
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TraceUser> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(TraceUser.getter(TraceUser::userName)).setter(TraceUser.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<List<ServiceId>> SERVICE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceIds").getter(TraceUser.getter(TraceUser::serviceIds)).setter(TraceUser.setter(Builder::serviceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, SERVICE_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userName;
    private final List<ServiceId> serviceIds;

    private TraceUser(BuilderImpl builder) {
        this.userName = builder.userName;
        this.serviceIds = builder.serviceIds;
    }

    public final String userName() {
        return this.userName;
    }

    public final boolean hasServiceIds() {
        return this.serviceIds != null && !(this.serviceIds instanceof SdkAutoConstructList);
    }

    public final List<ServiceId> serviceIds() {
        return this.serviceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceIds() ? this.serviceIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraceUser)) {
            return false;
        }
        TraceUser other = (TraceUser)obj;
        return Objects.equals(this.userName(), other.userName()) && this.hasServiceIds() == other.hasServiceIds() && Objects.equals(this.serviceIds(), other.serviceIds());
    }

    public final String toString() {
        return ToString.builder((String)"TraceUser").add("UserName", (Object)this.userName()).add("ServiceIds", this.hasServiceIds() ? this.serviceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "ServiceIds": {
                return Optional.ofNullable(clazz.cast(this.serviceIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TraceUser, T> g) {
        return obj -> g.apply((TraceUser)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private List<ServiceId> serviceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TraceUser model) {
            this.userName(model.userName);
            this.serviceIds(model.serviceIds);
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        @Transient
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final List<ServiceId.Builder> getServiceIds() {
            List<ServiceId.Builder> result = ServiceIdsCopier.copyToBuilder(this.serviceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceIds(Collection<ServiceId.BuilderImpl> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copyFromBuilder(serviceIds);
        }

        @Override
        @Transient
        public final Builder serviceIds(Collection<ServiceId> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copy(serviceIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serviceIds(ServiceId ... serviceIds) {
            this.serviceIds(Arrays.asList(serviceIds));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serviceIds(Consumer<ServiceId.Builder> ... serviceIds) {
            this.serviceIds(Stream.of(serviceIds).map(c -> (ServiceId)((ServiceId.Builder)ServiceId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TraceUser build() {
            return new TraceUser(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TraceUser> {
        public Builder userName(String var1);

        public Builder serviceIds(Collection<ServiceId> var1);

        public Builder serviceIds(ServiceId ... var1);

        public Builder serviceIds(Consumer<ServiceId.Builder> ... var1);
    }
}

