/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTimeSeriesServiceStatisticsRequest extends XRayRequest implements
        ToCopyableBuilder<GetTimeSeriesServiceStatisticsRequest.Builder, GetTimeSeriesServiceStatisticsRequest> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(GetTimeSeriesServiceStatisticsRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(GetTimeSeriesServiceStatisticsRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(GetTimeSeriesServiceStatisticsRequest::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupARN").getter(getter(GetTimeSeriesServiceStatisticsRequest::groupARN))
            .setter(setter(Builder::groupARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupARN").build()).build();

    private static final SdkField<String> ENTITY_SELECTOR_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntitySelectorExpression")
            .getter(getter(GetTimeSeriesServiceStatisticsRequest::entitySelectorExpression))
            .setter(setter(Builder::entitySelectorExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitySelectorExpression").build())
            .build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Period").getter(getter(GetTimeSeriesServiceStatisticsRequest::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final SdkField<Boolean> FORECAST_STATISTICS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForecastStatistics").getter(getter(GetTimeSeriesServiceStatisticsRequest::forecastStatistics))
            .setter(setter(Builder::forecastStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastStatistics").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetTimeSeriesServiceStatisticsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, GROUP_NAME_FIELD, GROUP_ARN_FIELD, ENTITY_SELECTOR_EXPRESSION_FIELD, PERIOD_FIELD,
            FORECAST_STATISTICS_FIELD, NEXT_TOKEN_FIELD));

    private final Instant startTime;

    private final Instant endTime;

    private final String groupName;

    private final String groupARN;

    private final String entitySelectorExpression;

    private final Integer period;

    private final Boolean forecastStatistics;

    private final String nextToken;

    private GetTimeSeriesServiceStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.groupName = builder.groupName;
        this.groupARN = builder.groupARN;
        this.entitySelectorExpression = builder.entitySelectorExpression;
        this.period = builder.period;
        this.forecastStatistics = builder.forecastStatistics;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The start of the time frame for which to aggregate statistics.
     * </p>
     * 
     * @return The start of the time frame for which to aggregate statistics.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time frame for which to aggregate statistics.
     * </p>
     * 
     * @return The end of the time frame for which to aggregate statistics.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The case-sensitive name of the group for which to pull statistics from.
     * </p>
     * 
     * @return The case-sensitive name of the group for which to pull statistics from.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the group for which to pull statistics from.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the group for which to pull statistics from.
     */
    public final String groupARN() {
        return groupARN;
    }

    /**
     * <p>
     * A filter expression defining entities that will be aggregated for statistics. Supports ID, service, and edge
     * functions. If no selector expression is specified, edge statistics are returned.
     * </p>
     * 
     * @return A filter expression defining entities that will be aggregated for statistics. Supports ID, service, and
     *         edge functions. If no selector expression is specified, edge statistics are returned.
     */
    public final String entitySelectorExpression() {
        return entitySelectorExpression;
    }

    /**
     * <p>
     * Aggregation period in seconds.
     * </p>
     * 
     * @return Aggregation period in seconds.
     */
    public final Integer period() {
        return period;
    }

    /**
     * <p>
     * The forecasted high and low fault count values. Forecast enabled requests require the EntitySelectorExpression ID
     * be provided.
     * </p>
     * 
     * @return The forecasted high and low fault count values. Forecast enabled requests require the
     *         EntitySelectorExpression ID be provided.
     */
    public final Boolean forecastStatistics() {
        return forecastStatistics;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(groupARN());
        hashCode = 31 * hashCode + Objects.hashCode(entitySelectorExpression());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(forecastStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTimeSeriesServiceStatisticsRequest)) {
            return false;
        }
        GetTimeSeriesServiceStatisticsRequest other = (GetTimeSeriesServiceStatisticsRequest) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(groupName(), other.groupName()) && Objects.equals(groupARN(), other.groupARN())
                && Objects.equals(entitySelectorExpression(), other.entitySelectorExpression())
                && Objects.equals(period(), other.period()) && Objects.equals(forecastStatistics(), other.forecastStatistics())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTimeSeriesServiceStatisticsRequest").add("StartTime", startTime()).add("EndTime", endTime())
                .add("GroupName", groupName()).add("GroupARN", groupARN())
                .add("EntitySelectorExpression", entitySelectorExpression()).add("Period", period())
                .add("ForecastStatistics", forecastStatistics()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "GroupARN":
            return Optional.ofNullable(clazz.cast(groupARN()));
        case "EntitySelectorExpression":
            return Optional.ofNullable(clazz.cast(entitySelectorExpression()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        case "ForecastStatistics":
            return Optional.ofNullable(clazz.cast(forecastStatistics()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTimeSeriesServiceStatisticsRequest, T> g) {
        return obj -> g.apply((GetTimeSeriesServiceStatisticsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTimeSeriesServiceStatisticsRequest> {
        /**
         * <p>
         * The start of the time frame for which to aggregate statistics.
         * </p>
         * 
         * @param startTime
         *        The start of the time frame for which to aggregate statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time frame for which to aggregate statistics.
         * </p>
         * 
         * @param endTime
         *        The end of the time frame for which to aggregate statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The case-sensitive name of the group for which to pull statistics from.
         * </p>
         * 
         * @param groupName
         *        The case-sensitive name of the group for which to pull statistics from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the group for which to pull statistics from.
         * </p>
         * 
         * @param groupARN
         *        The Amazon Resource Name (ARN) of the group for which to pull statistics from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupARN(String groupARN);

        /**
         * <p>
         * A filter expression defining entities that will be aggregated for statistics. Supports ID, service, and edge
         * functions. If no selector expression is specified, edge statistics are returned.
         * </p>
         * 
         * @param entitySelectorExpression
         *        A filter expression defining entities that will be aggregated for statistics. Supports ID, service,
         *        and edge functions. If no selector expression is specified, edge statistics are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitySelectorExpression(String entitySelectorExpression);

        /**
         * <p>
         * Aggregation period in seconds.
         * </p>
         * 
         * @param period
         *        Aggregation period in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The forecasted high and low fault count values. Forecast enabled requests require the
         * EntitySelectorExpression ID be provided.
         * </p>
         * 
         * @param forecastStatistics
         *        The forecasted high and low fault count values. Forecast enabled requests require the
         *        EntitySelectorExpression ID be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastStatistics(Boolean forecastStatistics);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends XRayRequest.BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private String groupName;

        private String groupARN;

        private String entitySelectorExpression;

        private Integer period;

        private Boolean forecastStatistics;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTimeSeriesServiceStatisticsRequest model) {
            super(model);
            startTime(model.startTime);
            endTime(model.endTime);
            groupName(model.groupName);
            groupARN(model.groupARN);
            entitySelectorExpression(model.entitySelectorExpression);
            period(model.period);
            forecastStatistics(model.forecastStatistics);
            nextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getGroupARN() {
            return groupARN;
        }

        @Override
        public final Builder groupARN(String groupARN) {
            this.groupARN = groupARN;
            return this;
        }

        public final void setGroupARN(String groupARN) {
            this.groupARN = groupARN;
        }

        public final String getEntitySelectorExpression() {
            return entitySelectorExpression;
        }

        @Override
        public final Builder entitySelectorExpression(String entitySelectorExpression) {
            this.entitySelectorExpression = entitySelectorExpression;
            return this;
        }

        public final void setEntitySelectorExpression(String entitySelectorExpression) {
            this.entitySelectorExpression = entitySelectorExpression;
        }

        public final Integer getPeriod() {
            return period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final Boolean getForecastStatistics() {
            return forecastStatistics;
        }

        @Override
        public final Builder forecastStatistics(Boolean forecastStatistics) {
            this.forecastStatistics = forecastStatistics;
            return this;
        }

        public final void setForecastStatistics(Boolean forecastStatistics) {
            this.forecastStatistics = forecastStatistics;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTimeSeriesServiceStatisticsRequest build() {
            return new GetTimeSeriesServiceStatisticsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
