/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InsightCategory {
    FAULT("FAULT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InsightCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InsightCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InsightCategory.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InsightCategory> knownValues() {
        return Stream.of(InsightCategory.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

