/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.ResponseTimeRootCauseEntity;
import software.amazon.awssdk.services.xray.model.ResponseTimeRootCauseEntityPathCopier;
import software.amazon.awssdk.services.xray.model.ServiceNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseTimeRootCauseService
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponseTimeRootCauseService> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ResponseTimeRootCauseService.getter(ResponseTimeRootCauseService::name)).setter(ResponseTimeRootCauseService.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Names").getter(ResponseTimeRootCauseService.getter(ResponseTimeRootCauseService::names)).setter(ResponseTimeRootCauseService.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ResponseTimeRootCauseService.getter(ResponseTimeRootCauseService::type)).setter(ResponseTimeRootCauseService.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ResponseTimeRootCauseService.getter(ResponseTimeRootCauseService::accountId)).setter(ResponseTimeRootCauseService.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<List<ResponseTimeRootCauseEntity>> ENTITY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityPath").getter(ResponseTimeRootCauseService.getter(ResponseTimeRootCauseService::entityPath)).setter(ResponseTimeRootCauseService.setter(Builder::entityPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityPath").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResponseTimeRootCauseEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INFERRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Inferred").getter(ResponseTimeRootCauseService.getter(ResponseTimeRootCauseService::inferred)).setter(ResponseTimeRootCauseService.setter(Builder::inferred)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inferred").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NAMES_FIELD, TYPE_FIELD, ACCOUNT_ID_FIELD, ENTITY_PATH_FIELD, INFERRED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> names;
    private final String type;
    private final String accountId;
    private final List<ResponseTimeRootCauseEntity> entityPath;
    private final Boolean inferred;

    private ResponseTimeRootCauseService(BuilderImpl builder) {
        this.name = builder.name;
        this.names = builder.names;
        this.type = builder.type;
        this.accountId = builder.accountId;
        this.entityPath = builder.entityPath;
        this.inferred = builder.inferred;
    }

    public String name() {
        return this.name;
    }

    public boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public List<String> names() {
        return this.names;
    }

    public String type() {
        return this.type;
    }

    public String accountId() {
        return this.accountId;
    }

    public boolean hasEntityPath() {
        return this.entityPath != null && !(this.entityPath instanceof SdkAutoConstructList);
    }

    public List<ResponseTimeRootCauseEntity> entityPath() {
        return this.entityPath;
    }

    public Boolean inferred() {
        return this.inferred;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNames() ? this.names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityPath() ? this.entityPath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inferred());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseTimeRootCauseService)) {
            return false;
        }
        ResponseTimeRootCauseService other = (ResponseTimeRootCauseService)obj;
        return Objects.equals(this.name(), other.name()) && this.hasNames() == other.hasNames() && Objects.equals(this.names(), other.names()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.accountId(), other.accountId()) && this.hasEntityPath() == other.hasEntityPath() && Objects.equals(this.entityPath(), other.entityPath()) && Objects.equals(this.inferred(), other.inferred());
    }

    public String toString() {
        return ToString.builder((String)"ResponseTimeRootCauseService").add("Name", (Object)this.name()).add("Names", this.hasNames() ? this.names() : null).add("Type", (Object)this.type()).add("AccountId", (Object)this.accountId()).add("EntityPath", this.hasEntityPath() ? this.entityPath() : null).add("Inferred", (Object)this.inferred()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "EntityPath": {
                return Optional.ofNullable(clazz.cast(this.entityPath()));
            }
            case "Inferred": {
                return Optional.ofNullable(clazz.cast(this.inferred()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResponseTimeRootCauseService, T> g) {
        return obj -> g.apply((ResponseTimeRootCauseService)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> names = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private String accountId;
        private List<ResponseTimeRootCauseEntity> entityPath = DefaultSdkAutoConstructList.getInstance();
        private Boolean inferred;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseTimeRootCauseService model) {
            this.name(model.name);
            this.names(model.names);
            this.type(model.type);
            this.accountId(model.accountId);
            this.entityPath(model.entityPath);
            this.inferred(model.inferred);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getNames() {
            if (this.names instanceof SdkAutoConstructList) {
                return null;
            }
            return this.names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = ServiceNamesCopier.copy(names);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Collection<ResponseTimeRootCauseEntity.Builder> getEntityPath() {
            if (this.entityPath instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entityPath != null ? (Collection)this.entityPath.stream().map(ResponseTimeRootCauseEntity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entityPath(Collection<ResponseTimeRootCauseEntity> entityPath) {
            this.entityPath = ResponseTimeRootCauseEntityPathCopier.copy(entityPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityPath(ResponseTimeRootCauseEntity ... entityPath) {
            this.entityPath(Arrays.asList(entityPath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityPath(Consumer<ResponseTimeRootCauseEntity.Builder> ... entityPath) {
            this.entityPath(Stream.of(entityPath).map(c -> (ResponseTimeRootCauseEntity)((ResponseTimeRootCauseEntity.Builder)ResponseTimeRootCauseEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntityPath(Collection<ResponseTimeRootCauseEntity.BuilderImpl> entityPath) {
            this.entityPath = ResponseTimeRootCauseEntityPathCopier.copyFromBuilder(entityPath);
        }

        public final Boolean getInferred() {
            return this.inferred;
        }

        @Override
        public final Builder inferred(Boolean inferred) {
            this.inferred = inferred;
            return this;
        }

        public final void setInferred(Boolean inferred) {
            this.inferred = inferred;
        }

        public ResponseTimeRootCauseService build() {
            return new ResponseTimeRootCauseService(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponseTimeRootCauseService> {
        public Builder name(String var1);

        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder type(String var1);

        public Builder accountId(String var1);

        public Builder entityPath(Collection<ResponseTimeRootCauseEntity> var1);

        public Builder entityPath(ResponseTimeRootCauseEntity ... var1);

        public Builder entityPath(Consumer<ResponseTimeRootCauseEntity.Builder> ... var1);

        public Builder inferred(Boolean var1);
    }
}

