/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.ErrorRootCauseService;
import software.amazon.awssdk.services.xray.model.ErrorRootCauseServicesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ErrorRootCause
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ErrorRootCause> {
    private static final SdkField<List<ErrorRootCauseService>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ErrorRootCause.getter(ErrorRootCause::services)).setter(ErrorRootCause.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorRootCauseService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> CLIENT_IMPACTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ErrorRootCause.getter(ErrorRootCause::clientImpacting)).setter(ErrorRootCause.setter(Builder::clientImpacting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientImpacting").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICES_FIELD, CLIENT_IMPACTING_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ErrorRootCauseService> services;
    private final Boolean clientImpacting;

    private ErrorRootCause(BuilderImpl builder) {
        this.services = builder.services;
        this.clientImpacting = builder.clientImpacting;
    }

    public boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public List<ErrorRootCauseService> services() {
        return this.services;
    }

    public Boolean clientImpacting() {
        return this.clientImpacting;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.services());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientImpacting());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorRootCause)) {
            return false;
        }
        ErrorRootCause other = (ErrorRootCause)obj;
        return Objects.equals(this.services(), other.services()) && Objects.equals(this.clientImpacting(), other.clientImpacting());
    }

    public String toString() {
        return ToString.builder((String)"ErrorRootCause").add("Services", this.services()).add("ClientImpacting", (Object)this.clientImpacting()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "ClientImpacting": {
                return Optional.ofNullable(clazz.cast(this.clientImpacting()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ErrorRootCause, T> g) {
        return obj -> g.apply((ErrorRootCause)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ErrorRootCauseService> services = DefaultSdkAutoConstructList.getInstance();
        private Boolean clientImpacting;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorRootCause model) {
            this.services(model.services);
            this.clientImpacting(model.clientImpacting);
        }

        public final Collection<ErrorRootCauseService.Builder> getServices() {
            return this.services != null ? (Collection)this.services.stream().map(ErrorRootCauseService::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder services(Collection<ErrorRootCauseService> services) {
            this.services = ErrorRootCauseServicesCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(ErrorRootCauseService ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<ErrorRootCauseService.Builder> ... services) {
            this.services(Stream.of(services).map(c -> (ErrorRootCauseService)((ErrorRootCauseService.Builder)ErrorRootCauseService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServices(Collection<ErrorRootCauseService.BuilderImpl> services) {
            this.services = ErrorRootCauseServicesCopier.copyFromBuilder(services);
        }

        public final Boolean getClientImpacting() {
            return this.clientImpacting;
        }

        @Override
        public final Builder clientImpacting(Boolean clientImpacting) {
            this.clientImpacting = clientImpacting;
            return this;
        }

        public final void setClientImpacting(Boolean clientImpacting) {
            this.clientImpacting = clientImpacting;
        }

        public ErrorRootCause build() {
            return new ErrorRootCause(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ErrorRootCause> {
        public Builder services(Collection<ErrorRootCauseService> var1);

        public Builder services(ErrorRootCauseService ... var1);

        public Builder services(Consumer<ErrorRootCauseService.Builder> ... var1);

        public Builder clientImpacting(Boolean var1);
    }
}

