/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a segment annotation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValueWithServiceIds implements SdkPojo, Serializable,
        ToCopyableBuilder<ValueWithServiceIds.Builder, ValueWithServiceIds> {
    private static final SdkField<AnnotationValue> ANNOTATION_VALUE_FIELD = SdkField
            .<AnnotationValue> builder(MarshallingType.SDK_POJO).getter(getter(ValueWithServiceIds::annotationValue))
            .setter(setter(Builder::annotationValue)).constructor(AnnotationValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnnotationValue").build()).build();

    private static final SdkField<List<ServiceId>> SERVICE_IDS_FIELD = SdkField
            .<List<ServiceId>> builder(MarshallingType.LIST)
            .getter(getter(ValueWithServiceIds::serviceIds))
            .setter(setter(Builder::serviceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceId> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceId::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATION_VALUE_FIELD,
            SERVICE_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AnnotationValue annotationValue;

    private final List<ServiceId> serviceIds;

    private ValueWithServiceIds(BuilderImpl builder) {
        this.annotationValue = builder.annotationValue;
        this.serviceIds = builder.serviceIds;
    }

    /**
     * <p>
     * Values of the annotation.
     * </p>
     * 
     * @return Values of the annotation.
     */
    public AnnotationValue annotationValue() {
        return annotationValue;
    }

    /**
     * Returns true if the ServiceIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasServiceIds() {
        return serviceIds != null && !(serviceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Services to which the annotation applies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServiceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Services to which the annotation applies.
     */
    public List<ServiceId> serviceIds() {
        return serviceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(annotationValue());
        hashCode = 31 * hashCode + Objects.hashCode(serviceIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValueWithServiceIds)) {
            return false;
        }
        ValueWithServiceIds other = (ValueWithServiceIds) obj;
        return Objects.equals(annotationValue(), other.annotationValue()) && Objects.equals(serviceIds(), other.serviceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ValueWithServiceIds").add("AnnotationValue", annotationValue()).add("ServiceIds", serviceIds())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnnotationValue":
            return Optional.ofNullable(clazz.cast(annotationValue()));
        case "ServiceIds":
            return Optional.ofNullable(clazz.cast(serviceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValueWithServiceIds, T> g) {
        return obj -> g.apply((ValueWithServiceIds) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValueWithServiceIds> {
        /**
         * <p>
         * Values of the annotation.
         * </p>
         * 
         * @param annotationValue
         *        Values of the annotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotationValue(AnnotationValue annotationValue);

        /**
         * <p>
         * Values of the annotation.
         * </p>
         * This is a convenience that creates an instance of the {@link AnnotationValue.Builder} avoiding the need to
         * create one manually via {@link AnnotationValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnnotationValue.Builder#build()} is called immediately and its
         * result is passed to {@link #annotationValue(AnnotationValue)}.
         * 
         * @param annotationValue
         *        a consumer that will call methods on {@link AnnotationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #annotationValue(AnnotationValue)
         */
        default Builder annotationValue(Consumer<AnnotationValue.Builder> annotationValue) {
            return annotationValue(AnnotationValue.builder().applyMutation(annotationValue).build());
        }

        /**
         * <p>
         * Services to which the annotation applies.
         * </p>
         * 
         * @param serviceIds
         *        Services to which the annotation applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIds(Collection<ServiceId> serviceIds);

        /**
         * <p>
         * Services to which the annotation applies.
         * </p>
         * 
         * @param serviceIds
         *        Services to which the annotation applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIds(ServiceId... serviceIds);

        /**
         * <p>
         * Services to which the annotation applies.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceId>.Builder} avoiding the need to
         * create one manually via {@link List<ServiceId>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceId>.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceIds(List<ServiceId>)}.
         * 
         * @param serviceIds
         *        a consumer that will call methods on {@link List<ServiceId>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceIds(List<ServiceId>)
         */
        Builder serviceIds(Consumer<ServiceId.Builder>... serviceIds);
    }

    static final class BuilderImpl implements Builder {
        private AnnotationValue annotationValue;

        private List<ServiceId> serviceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValueWithServiceIds model) {
            annotationValue(model.annotationValue);
            serviceIds(model.serviceIds);
        }

        public final AnnotationValue.Builder getAnnotationValue() {
            return annotationValue != null ? annotationValue.toBuilder() : null;
        }

        @Override
        public final Builder annotationValue(AnnotationValue annotationValue) {
            this.annotationValue = annotationValue;
            return this;
        }

        public final void setAnnotationValue(AnnotationValue.BuilderImpl annotationValue) {
            this.annotationValue = annotationValue != null ? annotationValue.build() : null;
        }

        public final Collection<ServiceId.Builder> getServiceIds() {
            return serviceIds != null ? serviceIds.stream().map(ServiceId::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceIds(Collection<ServiceId> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copy(serviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(ServiceId... serviceIds) {
            serviceIds(Arrays.asList(serviceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(Consumer<ServiceId.Builder>... serviceIds) {
            serviceIds(Stream.of(serviceIds).map(c -> ServiceId.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceIds(Collection<ServiceId.BuilderImpl> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copyFromBuilder(serviceIds);
        }

        @Override
        public ValueWithServiceIds build() {
            return new ValueWithServiceIds(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
