/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The root cause of a trace summary error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorRootCause implements SdkPojo, Serializable, ToCopyableBuilder<ErrorRootCause.Builder, ErrorRootCause> {
    private static final SdkField<List<ErrorRootCauseService>> SERVICES_FIELD = SdkField
            .<List<ErrorRootCauseService>> builder(MarshallingType.LIST)
            .getter(getter(ErrorRootCause::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ErrorRootCauseService> builder(MarshallingType.SDK_POJO)
                                            .constructor(ErrorRootCauseService::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> CLIENT_IMPACTING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ErrorRootCause::clientImpacting)).setter(setter(Builder::clientImpacting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientImpacting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICES_FIELD,
            CLIENT_IMPACTING_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ErrorRootCauseService> services;

    private final Boolean clientImpacting;

    private ErrorRootCause(BuilderImpl builder) {
        this.services = builder.services;
        this.clientImpacting = builder.clientImpacting;
    }

    /**
     * Returns true if the Services property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of services corresponding to an error. A service identifies a segment and it contains a name, account ID,
     * type, and inferred flag.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of services corresponding to an error. A service identifies a segment and it contains a name,
     *         account ID, type, and inferred flag.
     */
    public List<ErrorRootCauseService> services() {
        return services;
    }

    /**
     * <p>
     * A flag that denotes that the root cause impacts the trace client.
     * </p>
     * 
     * @return A flag that denotes that the root cause impacts the trace client.
     */
    public Boolean clientImpacting() {
        return clientImpacting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(services());
        hashCode = 31 * hashCode + Objects.hashCode(clientImpacting());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorRootCause)) {
            return false;
        }
        ErrorRootCause other = (ErrorRootCause) obj;
        return Objects.equals(services(), other.services()) && Objects.equals(clientImpacting(), other.clientImpacting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ErrorRootCause").add("Services", services()).add("ClientImpacting", clientImpacting()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Services":
            return Optional.ofNullable(clazz.cast(services()));
        case "ClientImpacting":
            return Optional.ofNullable(clazz.cast(clientImpacting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ErrorRootCause, T> g) {
        return obj -> g.apply((ErrorRootCause) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorRootCause> {
        /**
         * <p>
         * A list of services corresponding to an error. A service identifies a segment and it contains a name, account
         * ID, type, and inferred flag.
         * </p>
         * 
         * @param services
         *        A list of services corresponding to an error. A service identifies a segment and it contains a name,
         *        account ID, type, and inferred flag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<ErrorRootCauseService> services);

        /**
         * <p>
         * A list of services corresponding to an error. A service identifies a segment and it contains a name, account
         * ID, type, and inferred flag.
         * </p>
         * 
         * @param services
         *        A list of services corresponding to an error. A service identifies a segment and it contains a name,
         *        account ID, type, and inferred flag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(ErrorRootCauseService... services);

        /**
         * <p>
         * A list of services corresponding to an error. A service identifies a segment and it contains a name, account
         * ID, type, and inferred flag.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ErrorRootCauseService>.Builder} avoiding
         * the need to create one manually via {@link List<ErrorRootCauseService>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ErrorRootCauseService>.Builder#build()} is called
         * immediately and its result is passed to {@link #services(List<ErrorRootCauseService>)}.
         * 
         * @param services
         *        a consumer that will call methods on {@link List<ErrorRootCauseService>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #services(List<ErrorRootCauseService>)
         */
        Builder services(Consumer<ErrorRootCauseService.Builder>... services);

        /**
         * <p>
         * A flag that denotes that the root cause impacts the trace client.
         * </p>
         * 
         * @param clientImpacting
         *        A flag that denotes that the root cause impacts the trace client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientImpacting(Boolean clientImpacting);
    }

    static final class BuilderImpl implements Builder {
        private List<ErrorRootCauseService> services = DefaultSdkAutoConstructList.getInstance();

        private Boolean clientImpacting;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorRootCause model) {
            services(model.services);
            clientImpacting(model.clientImpacting);
        }

        public final Collection<ErrorRootCauseService.Builder> getServices() {
            return services != null ? services.stream().map(ErrorRootCauseService::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder services(Collection<ErrorRootCauseService> services) {
            this.services = ErrorRootCauseServicesCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(ErrorRootCauseService... services) {
            services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<ErrorRootCauseService.Builder>... services) {
            services(Stream.of(services).map(c -> ErrorRootCauseService.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setServices(Collection<ErrorRootCauseService.BuilderImpl> services) {
            this.services = ErrorRootCauseServicesCopier.copyFromBuilder(services);
        }

        public final Boolean getClientImpacting() {
            return clientImpacting;
        }

        @Override
        public final Builder clientImpacting(Boolean clientImpacting) {
            this.clientImpacting = clientImpacting;
            return this;
        }

        public final void setClientImpacting(Boolean clientImpacting) {
            this.clientImpacting = clientImpacting;
        }

        @Override
        public ErrorRootCause build() {
            return new ErrorRootCause(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
