/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.SamplingStatisticSummary;
import software.amazon.awssdk.services.xray.model.SamplingStatisticSummaryListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSamplingStatisticSummariesResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, GetSamplingStatisticSummariesResponse> {
    private static final SdkField<List<SamplingStatisticSummary>> SAMPLING_STATISTIC_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetSamplingStatisticSummariesResponse.getter(GetSamplingStatisticSummariesResponse::samplingStatisticSummaries)).setter(GetSamplingStatisticSummariesResponse.setter(Builder::samplingStatisticSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingStatisticSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SamplingStatisticSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSamplingStatisticSummariesResponse.getter(GetSamplingStatisticSummariesResponse::nextToken)).setter(GetSamplingStatisticSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLING_STATISTIC_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<SamplingStatisticSummary> samplingStatisticSummaries;
    private final String nextToken;

    private GetSamplingStatisticSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.samplingStatisticSummaries = builder.samplingStatisticSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasSamplingStatisticSummaries() {
        return this.samplingStatisticSummaries != null && !(this.samplingStatisticSummaries instanceof SdkAutoConstructList);
    }

    public List<SamplingStatisticSummary> samplingStatisticSummaries() {
        return this.samplingStatisticSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingStatisticSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSamplingStatisticSummariesResponse)) {
            return false;
        }
        GetSamplingStatisticSummariesResponse other = (GetSamplingStatisticSummariesResponse)((Object)obj);
        return Objects.equals(this.samplingStatisticSummaries(), other.samplingStatisticSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetSamplingStatisticSummariesResponse").add("SamplingStatisticSummaries", this.samplingStatisticSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SamplingStatisticSummaries": {
                return Optional.ofNullable(clazz.cast(this.samplingStatisticSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSamplingStatisticSummariesResponse, T> g) {
        return obj -> g.apply((GetSamplingStatisticSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<SamplingStatisticSummary> samplingStatisticSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSamplingStatisticSummariesResponse model) {
            super(model);
            this.samplingStatisticSummaries(model.samplingStatisticSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<SamplingStatisticSummary.Builder> getSamplingStatisticSummaries() {
            return this.samplingStatisticSummaries != null ? (Collection)this.samplingStatisticSummaries.stream().map(SamplingStatisticSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder samplingStatisticSummaries(Collection<SamplingStatisticSummary> samplingStatisticSummaries) {
            this.samplingStatisticSummaries = SamplingStatisticSummaryListCopier.copy(samplingStatisticSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samplingStatisticSummaries(SamplingStatisticSummary ... samplingStatisticSummaries) {
            this.samplingStatisticSummaries(Arrays.asList(samplingStatisticSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samplingStatisticSummaries(Consumer<SamplingStatisticSummary.Builder> ... samplingStatisticSummaries) {
            this.samplingStatisticSummaries(Stream.of(samplingStatisticSummaries).map(c -> (SamplingStatisticSummary)((SamplingStatisticSummary.Builder)SamplingStatisticSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSamplingStatisticSummaries(Collection<SamplingStatisticSummary.BuilderImpl> samplingStatisticSummaries) {
            this.samplingStatisticSummaries = SamplingStatisticSummaryListCopier.copyFromBuilder(samplingStatisticSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetSamplingStatisticSummariesResponse build() {
            return new GetSamplingStatisticSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSamplingStatisticSummariesResponse> {
        public Builder samplingStatisticSummaries(Collection<SamplingStatisticSummary> var1);

        public Builder samplingStatisticSummaries(SamplingStatisticSummary ... var1);

        public Builder samplingStatisticSummaries(Consumer<SamplingStatisticSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

