/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A segment from a trace that has been ingested by the X-Ray service. The segment can be compiled from documents
 * uploaded with <a>PutTraceSegments</a>, or an <code>inferred</code> segment for a downstream service, generated from a
 * subsegment sent by the service that called it.
 * </p>
 * <p>
 * For the full segment document schema, see <a
 * href="https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html">AWS X-Ray Segment
 * Documents</a> in the <i>AWS X-Ray Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Segment implements SdkPojo, Serializable, ToCopyableBuilder<Segment.Builder, Segment> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Segment::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Segment::document)).setter(setter(Builder::document))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Document").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DOCUMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String document;

    private Segment(BuilderImpl builder) {
        this.id = builder.id;
        this.document = builder.document;
    }

    /**
     * <p>
     * The segment's ID.
     * </p>
     * 
     * @return The segment's ID.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The segment document.
     * </p>
     * 
     * @return The segment document.
     */
    public String document() {
        return document;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(document());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Segment)) {
            return false;
        }
        Segment other = (Segment) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(document(), other.document());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Segment").add("Id", id()).add("Document", document()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Document":
            return Optional.ofNullable(clazz.cast(document()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Segment, T> g) {
        return obj -> g.apply((Segment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Segment> {
        /**
         * <p>
         * The segment's ID.
         * </p>
         * 
         * @param id
         *        The segment's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The segment document.
         * </p>
         * 
         * @param document
         *        The segment document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(String document);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String document;

        private BuilderImpl() {
        }

        private BuilderImpl(Segment model) {
            id(model.id);
            document(model.document);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDocument() {
            return document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        @Override
        public Segment build() {
            return new Segment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
