/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for a group without metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupSummary implements SdkPojo, Serializable, ToCopyableBuilder<GroupSummary.Builder, GroupSummary> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GroupSummary::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GroupSummary::groupARN)).setter(setter(Builder::groupARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupARN").build()).build();

    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GroupSummary::filterExpression)).setter(setter(Builder::filterExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            GROUP_ARN_FIELD, FILTER_EXPRESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupName;

    private final String groupARN;

    private final String filterExpression;

    private GroupSummary(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.groupARN = builder.groupARN;
        this.filterExpression = builder.filterExpression;
    }

    /**
     * <p>
     * The unique case-sensitive name of the group.
     * </p>
     * 
     * @return The unique case-sensitive name of the group.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The ARN of the group generated based on the GroupName.
     * </p>
     * 
     * @return The ARN of the group generated based on the GroupName.
     */
    public String groupARN() {
        return groupARN;
    }

    /**
     * <p>
     * The filter expression defining the parameters to include traces.
     * </p>
     * 
     * @return The filter expression defining the parameters to include traces.
     */
    public String filterExpression() {
        return filterExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(groupARN());
        hashCode = 31 * hashCode + Objects.hashCode(filterExpression());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupSummary)) {
            return false;
        }
        GroupSummary other = (GroupSummary) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(groupARN(), other.groupARN())
                && Objects.equals(filterExpression(), other.filterExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GroupSummary").add("GroupName", groupName()).add("GroupARN", groupARN())
                .add("FilterExpression", filterExpression()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "GroupARN":
            return Optional.ofNullable(clazz.cast(groupARN()));
        case "FilterExpression":
            return Optional.ofNullable(clazz.cast(filterExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupSummary, T> g) {
        return obj -> g.apply((GroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupSummary> {
        /**
         * <p>
         * The unique case-sensitive name of the group.
         * </p>
         * 
         * @param groupName
         *        The unique case-sensitive name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The ARN of the group generated based on the GroupName.
         * </p>
         * 
         * @param groupARN
         *        The ARN of the group generated based on the GroupName.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupARN(String groupARN);

        /**
         * <p>
         * The filter expression defining the parameters to include traces.
         * </p>
         * 
         * @param filterExpression
         *        The filter expression defining the parameters to include traces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterExpression(String filterExpression);
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private String groupARN;

        private String filterExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupSummary model) {
            groupName(model.groupName);
            groupARN(model.groupARN);
            filterExpression(model.filterExpression);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getGroupARN() {
            return groupARN;
        }

        @Override
        public final Builder groupARN(String groupARN) {
            this.groupARN = groupARN;
            return this;
        }

        public final void setGroupARN(String groupARN) {
            this.groupARN = groupARN;
        }

        public final String getFilterExpression() {
            return filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        @Override
        public GroupSummary build() {
            return new GroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
