/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of segments and corresponding subsegments associated to a trace summary error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorRootCauseEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<ErrorRootCauseEntity.Builder, ErrorRootCauseEntity> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ErrorRootCauseEntity::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<RootCauseException>> EXCEPTIONS_FIELD = SdkField
            .<List<RootCauseException>> builder(MarshallingType.LIST)
            .getter(getter(ErrorRootCauseEntity::exceptions))
            .setter(setter(Builder::exceptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exceptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RootCauseException> builder(MarshallingType.SDK_POJO)
                                            .constructor(RootCauseException::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> REMOTE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ErrorRootCauseEntity::remote)).setter(setter(Builder::remote))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Remote").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EXCEPTIONS_FIELD,
            REMOTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<RootCauseException> exceptions;

    private final Boolean remote;

    private ErrorRootCauseEntity(BuilderImpl builder) {
        this.name = builder.name;
        this.exceptions = builder.exceptions;
        this.remote = builder.remote;
    }

    /**
     * <p>
     * The name of the entity.
     * </p>
     * 
     * @return The name of the entity.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the Exceptions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasExceptions() {
        return exceptions != null && !(exceptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types and messages of the exceptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExceptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The types and messages of the exceptions.
     */
    public List<RootCauseException> exceptions() {
        return exceptions;
    }

    /**
     * <p>
     * A flag that denotes a remote subsegment.
     * </p>
     * 
     * @return A flag that denotes a remote subsegment.
     */
    public Boolean remote() {
        return remote;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(exceptions());
        hashCode = 31 * hashCode + Objects.hashCode(remote());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorRootCauseEntity)) {
            return false;
        }
        ErrorRootCauseEntity other = (ErrorRootCauseEntity) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(exceptions(), other.exceptions())
                && Objects.equals(remote(), other.remote());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ErrorRootCauseEntity").add("Name", name()).add("Exceptions", exceptions())
                .add("Remote", remote()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Exceptions":
            return Optional.ofNullable(clazz.cast(exceptions()));
        case "Remote":
            return Optional.ofNullable(clazz.cast(remote()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ErrorRootCauseEntity, T> g) {
        return obj -> g.apply((ErrorRootCauseEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorRootCauseEntity> {
        /**
         * <p>
         * The name of the entity.
         * </p>
         * 
         * @param name
         *        The name of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The types and messages of the exceptions.
         * </p>
         * 
         * @param exceptions
         *        The types and messages of the exceptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exceptions(Collection<RootCauseException> exceptions);

        /**
         * <p>
         * The types and messages of the exceptions.
         * </p>
         * 
         * @param exceptions
         *        The types and messages of the exceptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exceptions(RootCauseException... exceptions);

        /**
         * <p>
         * The types and messages of the exceptions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RootCauseException>.Builder} avoiding the
         * need to create one manually via {@link List<RootCauseException>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RootCauseException>.Builder#build()} is called immediately
         * and its result is passed to {@link #exceptions(List<RootCauseException>)}.
         * 
         * @param exceptions
         *        a consumer that will call methods on {@link List<RootCauseException>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exceptions(List<RootCauseException>)
         */
        Builder exceptions(Consumer<RootCauseException.Builder>... exceptions);

        /**
         * <p>
         * A flag that denotes a remote subsegment.
         * </p>
         * 
         * @param remote
         *        A flag that denotes a remote subsegment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remote(Boolean remote);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<RootCauseException> exceptions = DefaultSdkAutoConstructList.getInstance();

        private Boolean remote;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorRootCauseEntity model) {
            name(model.name);
            exceptions(model.exceptions);
            remote(model.remote);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<RootCauseException.Builder> getExceptions() {
            return exceptions != null ? exceptions.stream().map(RootCauseException::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder exceptions(Collection<RootCauseException> exceptions) {
            this.exceptions = RootCauseExceptionsCopier.copy(exceptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exceptions(RootCauseException... exceptions) {
            exceptions(Arrays.asList(exceptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exceptions(Consumer<RootCauseException.Builder>... exceptions) {
            exceptions(Stream.of(exceptions).map(c -> RootCauseException.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setExceptions(Collection<RootCauseException.BuilderImpl> exceptions) {
            this.exceptions = RootCauseExceptionsCopier.copyFromBuilder(exceptions);
        }

        public final Boolean getRemote() {
            return remote;
        }

        @Override
        public final Builder remote(Boolean remote) {
            this.remote = remote;
            return this;
        }

        public final void setRemote(Boolean remote) {
            this.remote = remote;
        }

        @Override
        public ErrorRootCauseEntity build() {
            return new ErrorRootCauseEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
