/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.ServiceStatistics;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ServiceStatisticsMarshaller {
    private static final MarshallingInfo<Long> OKCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OkCount").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ERRORSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorStatistics").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FAULTSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FaultStatistics").isBinary(false).build();
    private static final MarshallingInfo<Long> TOTALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalCount").isBinary(false).build();
    private static final MarshallingInfo<Double> TOTALRESPONSETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalResponseTime").isBinary(false).build();
    private static final ServiceStatisticsMarshaller INSTANCE = new ServiceStatisticsMarshaller();

    private ServiceStatisticsMarshaller() {
    }

    public static ServiceStatisticsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ServiceStatistics serviceStatistics, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)serviceStatistics, (String)"serviceStatistics");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)serviceStatistics.okCount(), OKCOUNT_BINDING);
            protocolMarshaller.marshall((Object)serviceStatistics.errorStatistics(), ERRORSTATISTICS_BINDING);
            protocolMarshaller.marshall((Object)serviceStatistics.faultStatistics(), FAULTSTATISTICS_BINDING);
            protocolMarshaller.marshall((Object)serviceStatistics.totalCount(), TOTALCOUNT_BINDING);
            protocolMarshaller.marshall((Object)serviceStatistics.totalResponseTime(), TOTALRESPONSETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

