/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.AnnotationValue;
import software.amazon.awssdk.services.xray.model.ServiceId;
import software.amazon.awssdk.services.xray.model.ServiceIdsCopier;
import software.amazon.awssdk.services.xray.transform.ValueWithServiceIdsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValueWithServiceIds
implements StructuredPojo,
ToCopyableBuilder<Builder, ValueWithServiceIds> {
    private final AnnotationValue annotationValue;
    private final List<ServiceId> serviceIds;

    private ValueWithServiceIds(BuilderImpl builder) {
        this.annotationValue = builder.annotationValue;
        this.serviceIds = builder.serviceIds;
    }

    public AnnotationValue annotationValue() {
        return this.annotationValue;
    }

    public List<ServiceId> serviceIds() {
        return this.serviceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.annotationValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValueWithServiceIds)) {
            return false;
        }
        ValueWithServiceIds other = (ValueWithServiceIds)obj;
        return Objects.equals(this.annotationValue(), other.annotationValue()) && Objects.equals(this.serviceIds(), other.serviceIds());
    }

    public String toString() {
        return ToString.builder((String)"ValueWithServiceIds").add("AnnotationValue", (Object)this.annotationValue()).add("ServiceIds", this.serviceIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnnotationValue": {
                return Optional.of(clazz.cast(this.annotationValue()));
            }
            case "ServiceIds": {
                return Optional.of(clazz.cast(this.serviceIds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ValueWithServiceIdsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private AnnotationValue annotationValue;
        private List<ServiceId> serviceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ValueWithServiceIds model) {
            this.annotationValue(model.annotationValue);
            this.serviceIds(model.serviceIds);
        }

        public final AnnotationValue.Builder getAnnotationValue() {
            return this.annotationValue != null ? this.annotationValue.toBuilder() : null;
        }

        @Override
        public final Builder annotationValue(AnnotationValue annotationValue) {
            this.annotationValue = annotationValue;
            return this;
        }

        public final void setAnnotationValue(AnnotationValue.BuilderImpl annotationValue) {
            this.annotationValue = annotationValue != null ? annotationValue.build() : null;
        }

        public final Collection<ServiceId.Builder> getServiceIds() {
            return this.serviceIds != null ? (Collection)this.serviceIds.stream().map(ServiceId::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceIds(Collection<ServiceId> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copy(serviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(ServiceId ... serviceIds) {
            this.serviceIds(Arrays.asList(serviceIds));
            return this;
        }

        public final void setServiceIds(Collection<ServiceId.BuilderImpl> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copyFromBuilder(serviceIds);
        }

        public ValueWithServiceIds build() {
            return new ValueWithServiceIds(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValueWithServiceIds> {
        public Builder annotationValue(AnnotationValue var1);

        default public Builder annotationValue(Consumer<AnnotationValue.Builder> annotationValue) {
            return this.annotationValue((AnnotationValue)((AnnotationValue.Builder)AnnotationValue.builder().apply(annotationValue)).build());
        }

        public Builder serviceIds(Collection<ServiceId> var1);

        public Builder serviceIds(ServiceId ... var1);
    }
}

