/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.BackendConnectionErrors;
import software.amazon.awssdk.services.xray.transform.TelemetryRecordMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TelemetryRecord
implements StructuredPojo,
ToCopyableBuilder<Builder, TelemetryRecord> {
    private final Instant timestamp;
    private final Integer segmentsReceivedCount;
    private final Integer segmentsSentCount;
    private final Integer segmentsSpilloverCount;
    private final Integer segmentsRejectedCount;
    private final BackendConnectionErrors backendConnectionErrors;

    private TelemetryRecord(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.segmentsReceivedCount = builder.segmentsReceivedCount;
        this.segmentsSentCount = builder.segmentsSentCount;
        this.segmentsSpilloverCount = builder.segmentsSpilloverCount;
        this.segmentsRejectedCount = builder.segmentsRejectedCount;
        this.backendConnectionErrors = builder.backendConnectionErrors;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Integer segmentsReceivedCount() {
        return this.segmentsReceivedCount;
    }

    public Integer segmentsSentCount() {
        return this.segmentsSentCount;
    }

    public Integer segmentsSpilloverCount() {
        return this.segmentsSpilloverCount;
    }

    public Integer segmentsRejectedCount() {
        return this.segmentsRejectedCount;
    }

    public BackendConnectionErrors backendConnectionErrors() {
        return this.backendConnectionErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentsReceivedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentsSentCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentsSpilloverCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentsRejectedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.backendConnectionErrors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryRecord)) {
            return false;
        }
        TelemetryRecord other = (TelemetryRecord)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.segmentsReceivedCount(), other.segmentsReceivedCount()) && Objects.equals(this.segmentsSentCount(), other.segmentsSentCount()) && Objects.equals(this.segmentsSpilloverCount(), other.segmentsSpilloverCount()) && Objects.equals(this.segmentsRejectedCount(), other.segmentsRejectedCount()) && Objects.equals(this.backendConnectionErrors(), other.backendConnectionErrors());
    }

    public String toString() {
        return ToString.builder((String)"TelemetryRecord").add("Timestamp", (Object)this.timestamp()).add("SegmentsReceivedCount", (Object)this.segmentsReceivedCount()).add("SegmentsSentCount", (Object)this.segmentsSentCount()).add("SegmentsSpilloverCount", (Object)this.segmentsSpilloverCount()).add("SegmentsRejectedCount", (Object)this.segmentsRejectedCount()).add("BackendConnectionErrors", (Object)this.backendConnectionErrors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.of(clazz.cast(this.timestamp()));
            }
            case "SegmentsReceivedCount": {
                return Optional.of(clazz.cast(this.segmentsReceivedCount()));
            }
            case "SegmentsSentCount": {
                return Optional.of(clazz.cast(this.segmentsSentCount()));
            }
            case "SegmentsSpilloverCount": {
                return Optional.of(clazz.cast(this.segmentsSpilloverCount()));
            }
            case "SegmentsRejectedCount": {
                return Optional.of(clazz.cast(this.segmentsRejectedCount()));
            }
            case "BackendConnectionErrors": {
                return Optional.of(clazz.cast(this.backendConnectionErrors()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TelemetryRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private Integer segmentsReceivedCount;
        private Integer segmentsSentCount;
        private Integer segmentsSpilloverCount;
        private Integer segmentsRejectedCount;
        private BackendConnectionErrors backendConnectionErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryRecord model) {
            this.timestamp(model.timestamp);
            this.segmentsReceivedCount(model.segmentsReceivedCount);
            this.segmentsSentCount(model.segmentsSentCount);
            this.segmentsSpilloverCount(model.segmentsSpilloverCount);
            this.segmentsRejectedCount(model.segmentsRejectedCount);
            this.backendConnectionErrors(model.backendConnectionErrors);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Integer getSegmentsReceivedCount() {
            return this.segmentsReceivedCount;
        }

        @Override
        public final Builder segmentsReceivedCount(Integer segmentsReceivedCount) {
            this.segmentsReceivedCount = segmentsReceivedCount;
            return this;
        }

        public final void setSegmentsReceivedCount(Integer segmentsReceivedCount) {
            this.segmentsReceivedCount = segmentsReceivedCount;
        }

        public final Integer getSegmentsSentCount() {
            return this.segmentsSentCount;
        }

        @Override
        public final Builder segmentsSentCount(Integer segmentsSentCount) {
            this.segmentsSentCount = segmentsSentCount;
            return this;
        }

        public final void setSegmentsSentCount(Integer segmentsSentCount) {
            this.segmentsSentCount = segmentsSentCount;
        }

        public final Integer getSegmentsSpilloverCount() {
            return this.segmentsSpilloverCount;
        }

        @Override
        public final Builder segmentsSpilloverCount(Integer segmentsSpilloverCount) {
            this.segmentsSpilloverCount = segmentsSpilloverCount;
            return this;
        }

        public final void setSegmentsSpilloverCount(Integer segmentsSpilloverCount) {
            this.segmentsSpilloverCount = segmentsSpilloverCount;
        }

        public final Integer getSegmentsRejectedCount() {
            return this.segmentsRejectedCount;
        }

        @Override
        public final Builder segmentsRejectedCount(Integer segmentsRejectedCount) {
            this.segmentsRejectedCount = segmentsRejectedCount;
            return this;
        }

        public final void setSegmentsRejectedCount(Integer segmentsRejectedCount) {
            this.segmentsRejectedCount = segmentsRejectedCount;
        }

        public final BackendConnectionErrors.Builder getBackendConnectionErrors() {
            return this.backendConnectionErrors != null ? this.backendConnectionErrors.toBuilder() : null;
        }

        @Override
        public final Builder backendConnectionErrors(BackendConnectionErrors backendConnectionErrors) {
            this.backendConnectionErrors = backendConnectionErrors;
            return this;
        }

        public final void setBackendConnectionErrors(BackendConnectionErrors.BuilderImpl backendConnectionErrors) {
            this.backendConnectionErrors = backendConnectionErrors != null ? backendConnectionErrors.build() : null;
        }

        public TelemetryRecord build() {
            return new TelemetryRecord(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TelemetryRecord> {
        public Builder timestamp(Instant var1);

        public Builder segmentsReceivedCount(Integer var1);

        public Builder segmentsSentCount(Integer var1);

        public Builder segmentsSpilloverCount(Integer var1);

        public Builder segmentsRejectedCount(Integer var1);

        public Builder backendConnectionErrors(BackendConnectionErrors var1);

        default public Builder backendConnectionErrors(Consumer<BackendConnectionErrors.Builder> backendConnectionErrors) {
            return this.backendConnectionErrors((BackendConnectionErrors)((BackendConnectionErrors.Builder)BackendConnectionErrors.builder().apply(backendConnectionErrors)).build());
        }
    }
}

