/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.xray.model.Trace;
import software.amazon.awssdk.services.xray.model.TraceListCopier;
import software.amazon.awssdk.services.xray.model.UnprocessedTraceIdListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetTracesResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, BatchGetTracesResponse> {
    private final List<Trace> traces;
    private final List<String> unprocessedTraceIds;
    private final String nextToken;

    private BatchGetTracesResponse(BuilderImpl builder) {
        super(builder);
        this.traces = builder.traces;
        this.unprocessedTraceIds = builder.unprocessedTraceIds;
        this.nextToken = builder.nextToken;
    }

    public List<Trace> traces() {
        return this.traces;
    }

    public List<String> unprocessedTraceIds() {
        return this.unprocessedTraceIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.traces());
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedTraceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTracesResponse)) {
            return false;
        }
        BatchGetTracesResponse other = (BatchGetTracesResponse)((Object)obj);
        return Objects.equals(this.traces(), other.traces()) && Objects.equals(this.unprocessedTraceIds(), other.unprocessedTraceIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetTracesResponse").add("Traces", this.traces()).add("UnprocessedTraceIds", this.unprocessedTraceIds()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Traces": {
                return Optional.of(clazz.cast(this.traces()));
            }
            case "UnprocessedTraceIds": {
                return Optional.of(clazz.cast(this.unprocessedTraceIds()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<Trace> traces;
        private List<String> unprocessedTraceIds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTracesResponse model) {
            this.traces(model.traces);
            this.unprocessedTraceIds(model.unprocessedTraceIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<Trace.Builder> getTraces() {
            return this.traces != null ? (Collection)this.traces.stream().map(Trace::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder traces(Collection<Trace> traces) {
            this.traces = TraceListCopier.copy(traces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traces(Trace ... traces) {
            this.traces(Arrays.asList(traces));
            return this;
        }

        public final void setTraces(Collection<Trace.BuilderImpl> traces) {
            this.traces = TraceListCopier.copyFromBuilder(traces);
        }

        public final Collection<String> getUnprocessedTraceIds() {
            return this.unprocessedTraceIds;
        }

        @Override
        public final Builder unprocessedTraceIds(Collection<String> unprocessedTraceIds) {
            this.unprocessedTraceIds = UnprocessedTraceIdListCopier.copy(unprocessedTraceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedTraceIds(String ... unprocessedTraceIds) {
            this.unprocessedTraceIds(Arrays.asList(unprocessedTraceIds));
            return this;
        }

        public final void setUnprocessedTraceIds(Collection<String> unprocessedTraceIds) {
            this.unprocessedTraceIds = UnprocessedTraceIdListCopier.copy(unprocessedTraceIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public BatchGetTracesResponse build() {
            return new BatchGetTracesResponse(this);
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    CopyableBuilder<Builder, BatchGetTracesResponse> {
        public Builder traces(Collection<Trace> var1);

        public Builder traces(Trace ... var1);

        public Builder unprocessedTraceIds(Collection<String> var1);

        public Builder unprocessedTraceIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

