/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.BackendConnectionErrors;

@SdkInternalApi
public class BackendConnectionErrorsMarshaller {
    private static final MarshallingInfo<Integer> TIMEOUTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeoutCount").build();
    private static final MarshallingInfo<Integer> CONNECTIONREFUSEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionRefusedCount").build();
    private static final MarshallingInfo<Integer> HTTPCODE4XXCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HTTPCode4XXCount").build();
    private static final MarshallingInfo<Integer> HTTPCODE5XXCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HTTPCode5XXCount").build();
    private static final MarshallingInfo<Integer> UNKNOWNHOSTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UnknownHostCount").build();
    private static final MarshallingInfo<Integer> OTHERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OtherCount").build();
    private static final BackendConnectionErrorsMarshaller INSTANCE = new BackendConnectionErrorsMarshaller();

    public static BackendConnectionErrorsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BackendConnectionErrors backendConnectionErrors, ProtocolMarshaller protocolMarshaller) {
        if (backendConnectionErrors == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)backendConnectionErrors.timeoutCount(), TIMEOUTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)backendConnectionErrors.connectionRefusedCount(), CONNECTIONREFUSEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)backendConnectionErrors.httpCode4XXCount(), HTTPCODE4XXCOUNT_BINDING);
            protocolMarshaller.marshall((Object)backendConnectionErrors.httpCode5XXCount(), HTTPCODE5XXCOUNT_BINDING);
            protocolMarshaller.marshall((Object)backendConnectionErrors.unknownHostCount(), UNKNOWNHOSTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)backendConnectionErrors.otherCount(), OTHERCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

