/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.xray.model.UnprocessedTraceSegment;
import software.amazon.awssdk.services.xray.model.UnprocessedTraceSegmentListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutTraceSegmentsResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, PutTraceSegmentsResponse> {
    private final List<UnprocessedTraceSegment> unprocessedTraceSegments;

    private PutTraceSegmentsResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedTraceSegments = builder.unprocessedTraceSegments;
    }

    public List<UnprocessedTraceSegment> unprocessedTraceSegments() {
        return this.unprocessedTraceSegments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedTraceSegments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTraceSegmentsResponse)) {
            return false;
        }
        PutTraceSegmentsResponse other = (PutTraceSegmentsResponse)((Object)obj);
        return Objects.equals(this.unprocessedTraceSegments(), other.unprocessedTraceSegments());
    }

    public String toString() {
        return ToString.builder((String)"PutTraceSegmentsResponse").add("UnprocessedTraceSegments", this.unprocessedTraceSegments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UnprocessedTraceSegments": {
                return Optional.of(clazz.cast(this.unprocessedTraceSegments()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<UnprocessedTraceSegment> unprocessedTraceSegments;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTraceSegmentsResponse model) {
            this.unprocessedTraceSegments(model.unprocessedTraceSegments);
        }

        public final Collection<UnprocessedTraceSegment.Builder> getUnprocessedTraceSegments() {
            return this.unprocessedTraceSegments != null ? (Collection)this.unprocessedTraceSegments.stream().map(UnprocessedTraceSegment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedTraceSegments(Collection<UnprocessedTraceSegment> unprocessedTraceSegments) {
            this.unprocessedTraceSegments = UnprocessedTraceSegmentListCopier.copy(unprocessedTraceSegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedTraceSegments(UnprocessedTraceSegment ... unprocessedTraceSegments) {
            this.unprocessedTraceSegments(Arrays.asList(unprocessedTraceSegments));
            return this;
        }

        public final void setUnprocessedTraceSegments(Collection<UnprocessedTraceSegment.BuilderImpl> unprocessedTraceSegments) {
            this.unprocessedTraceSegments = UnprocessedTraceSegmentListCopier.copyFromBuilder(unprocessedTraceSegments);
        }

        @Override
        public PutTraceSegmentsResponse build() {
            return new PutTraceSegmentsResponse(this);
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    CopyableBuilder<Builder, PutTraceSegmentsResponse> {
        public Builder unprocessedTraceSegments(Collection<UnprocessedTraceSegment> var1);

        public Builder unprocessedTraceSegments(UnprocessedTraceSegment ... var1);
    }
}

