/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.transform.ErrorStatisticsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ErrorStatistics
implements StructuredPojo,
ToCopyableBuilder<Builder, ErrorStatistics> {
    private final Long throttleCount;
    private final Long otherCount;
    private final Long totalCount;

    private ErrorStatistics(BuilderImpl builder) {
        this.throttleCount = builder.throttleCount;
        this.otherCount = builder.otherCount;
        this.totalCount = builder.totalCount;
    }

    public Long throttleCount() {
        return this.throttleCount;
    }

    public Long otherCount() {
        return this.otherCount;
    }

    public Long totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.throttleCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.otherCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorStatistics)) {
            return false;
        }
        ErrorStatistics other = (ErrorStatistics)obj;
        return Objects.equals(this.throttleCount(), other.throttleCount()) && Objects.equals(this.otherCount(), other.otherCount()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public String toString() {
        return ToString.builder((String)"ErrorStatistics").add("ThrottleCount", (Object)this.throttleCount()).add("OtherCount", (Object)this.otherCount()).add("TotalCount", (Object)this.totalCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ThrottleCount": {
                return Optional.of(clazz.cast(this.throttleCount()));
            }
            case "OtherCount": {
                return Optional.of(clazz.cast(this.otherCount()));
            }
            case "TotalCount": {
                return Optional.of(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ErrorStatisticsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long throttleCount;
        private Long otherCount;
        private Long totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorStatistics model) {
            this.throttleCount(model.throttleCount);
            this.otherCount(model.otherCount);
            this.totalCount(model.totalCount);
        }

        public final Long getThrottleCount() {
            return this.throttleCount;
        }

        @Override
        public final Builder throttleCount(Long throttleCount) {
            this.throttleCount = throttleCount;
            return this;
        }

        public final void setThrottleCount(Long throttleCount) {
            this.throttleCount = throttleCount;
        }

        public final Long getOtherCount() {
            return this.otherCount;
        }

        @Override
        public final Builder otherCount(Long otherCount) {
            this.otherCount = otherCount;
            return this;
        }

        public final void setOtherCount(Long otherCount) {
            this.otherCount = otherCount;
        }

        public final Long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        public ErrorStatistics build() {
            return new ErrorStatistics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ErrorStatistics> {
        public Builder throttleCount(Long var1);

        public Builder otherCount(Long var1);

        public Builder totalCount(Long var1);
    }
}

