/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.ErrorStatistics;
import software.amazon.awssdk.services.xray.model.FaultStatistics;
import software.amazon.awssdk.services.xray.transform.EdgeStatisticsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EdgeStatistics
implements StructuredPojo,
ToCopyableBuilder<Builder, EdgeStatistics> {
    private final Long okCount;
    private final ErrorStatistics errorStatistics;
    private final FaultStatistics faultStatistics;
    private final Long totalCount;
    private final Double totalResponseTime;

    private EdgeStatistics(BuilderImpl builder) {
        this.okCount = builder.okCount;
        this.errorStatistics = builder.errorStatistics;
        this.faultStatistics = builder.faultStatistics;
        this.totalCount = builder.totalCount;
        this.totalResponseTime = builder.totalResponseTime;
    }

    public Long okCount() {
        return this.okCount;
    }

    public ErrorStatistics errorStatistics() {
        return this.errorStatistics;
    }

    public FaultStatistics faultStatistics() {
        return this.faultStatistics;
    }

    public Long totalCount() {
        return this.totalCount;
    }

    public Double totalResponseTime() {
        return this.totalResponseTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.okCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.faultStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResponseTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeStatistics)) {
            return false;
        }
        EdgeStatistics other = (EdgeStatistics)obj;
        return Objects.equals(this.okCount(), other.okCount()) && Objects.equals(this.errorStatistics(), other.errorStatistics()) && Objects.equals(this.faultStatistics(), other.faultStatistics()) && Objects.equals(this.totalCount(), other.totalCount()) && Objects.equals(this.totalResponseTime(), other.totalResponseTime());
    }

    public String toString() {
        return ToString.builder((String)"EdgeStatistics").add("OkCount", (Object)this.okCount()).add("ErrorStatistics", (Object)this.errorStatistics()).add("FaultStatistics", (Object)this.faultStatistics()).add("TotalCount", (Object)this.totalCount()).add("TotalResponseTime", (Object)this.totalResponseTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OkCount": {
                return Optional.of(clazz.cast(this.okCount()));
            }
            case "ErrorStatistics": {
                return Optional.of(clazz.cast(this.errorStatistics()));
            }
            case "FaultStatistics": {
                return Optional.of(clazz.cast(this.faultStatistics()));
            }
            case "TotalCount": {
                return Optional.of(clazz.cast(this.totalCount()));
            }
            case "TotalResponseTime": {
                return Optional.of(clazz.cast(this.totalResponseTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EdgeStatisticsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long okCount;
        private ErrorStatistics errorStatistics;
        private FaultStatistics faultStatistics;
        private Long totalCount;
        private Double totalResponseTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeStatistics model) {
            this.okCount(model.okCount);
            this.errorStatistics(model.errorStatistics);
            this.faultStatistics(model.faultStatistics);
            this.totalCount(model.totalCount);
            this.totalResponseTime(model.totalResponseTime);
        }

        public final Long getOkCount() {
            return this.okCount;
        }

        @Override
        public final Builder okCount(Long okCount) {
            this.okCount = okCount;
            return this;
        }

        public final void setOkCount(Long okCount) {
            this.okCount = okCount;
        }

        public final ErrorStatistics.Builder getErrorStatistics() {
            return this.errorStatistics != null ? this.errorStatistics.toBuilder() : null;
        }

        @Override
        public final Builder errorStatistics(ErrorStatistics errorStatistics) {
            this.errorStatistics = errorStatistics;
            return this;
        }

        public final void setErrorStatistics(ErrorStatistics.BuilderImpl errorStatistics) {
            this.errorStatistics = errorStatistics != null ? errorStatistics.build() : null;
        }

        public final FaultStatistics.Builder getFaultStatistics() {
            return this.faultStatistics != null ? this.faultStatistics.toBuilder() : null;
        }

        @Override
        public final Builder faultStatistics(FaultStatistics faultStatistics) {
            this.faultStatistics = faultStatistics;
            return this;
        }

        public final void setFaultStatistics(FaultStatistics.BuilderImpl faultStatistics) {
            this.faultStatistics = faultStatistics != null ? faultStatistics.build() : null;
        }

        public final Long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        public final Double getTotalResponseTime() {
            return this.totalResponseTime;
        }

        @Override
        public final Builder totalResponseTime(Double totalResponseTime) {
            this.totalResponseTime = totalResponseTime;
            return this;
        }

        public final void setTotalResponseTime(Double totalResponseTime) {
            this.totalResponseTime = totalResponseTime;
        }

        public EdgeStatistics build() {
            return new EdgeStatistics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EdgeStatistics> {
        public Builder okCount(Long var1);

        public Builder errorStatistics(ErrorStatistics var1);

        default public Builder errorStatistics(Consumer<ErrorStatistics.Builder> errorStatistics) {
            return this.errorStatistics((ErrorStatistics)((ErrorStatistics.Builder)ErrorStatistics.builder().apply(errorStatistics)).build());
        }

        public Builder faultStatistics(FaultStatistics var1);

        default public Builder faultStatistics(Consumer<FaultStatistics.Builder> faultStatistics) {
            return this.faultStatistics((FaultStatistics)((FaultStatistics.Builder)FaultStatistics.builder().apply(faultStatistics)).build());
        }

        public Builder totalCount(Long var1);

        public Builder totalResponseTime(Double var1);
    }
}

