/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.TelemetryRecord;

@SdkInternalApi
public class TelemetryRecordMarshaller {
    private static final MarshallingInfo<Instant> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").build();
    private static final MarshallingInfo<Integer> SEGMENTSRECEIVEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentsReceivedCount").build();
    private static final MarshallingInfo<Integer> SEGMENTSSENTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentsSentCount").build();
    private static final MarshallingInfo<Integer> SEGMENTSSPILLOVERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentsSpilloverCount").build();
    private static final MarshallingInfo<Integer> SEGMENTSREJECTEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentsRejectedCount").build();
    private static final MarshallingInfo<StructuredPojo> BACKENDCONNECTIONERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackendConnectionErrors").build();
    private static final TelemetryRecordMarshaller INSTANCE = new TelemetryRecordMarshaller();

    public static TelemetryRecordMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TelemetryRecord telemetryRecord, ProtocolMarshaller protocolMarshaller) {
        if (telemetryRecord == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)telemetryRecord.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)telemetryRecord.segmentsReceivedCount(), SEGMENTSRECEIVEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)telemetryRecord.segmentsSentCount(), SEGMENTSSENTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)telemetryRecord.segmentsSpilloverCount(), SEGMENTSSPILLOVERCOUNT_BINDING);
            protocolMarshaller.marshall((Object)telemetryRecord.segmentsRejectedCount(), SEGMENTSREJECTEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)telemetryRecord.backendConnectionErrors(), BACKENDCONNECTIONERRORS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

