/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.Http;

@SdkInternalApi
public class HttpMarshaller {
    private static final MarshallingInfo<String> HTTPURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HttpURL").build();
    private static final MarshallingInfo<Integer> HTTPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HttpStatus").build();
    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HttpMethod").build();
    private static final MarshallingInfo<String> USERAGENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserAgent").build();
    private static final MarshallingInfo<String> CLIENTIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientIp").build();
    private static final HttpMarshaller INSTANCE = new HttpMarshaller();

    public static HttpMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Http http, ProtocolMarshaller protocolMarshaller) {
        if (http == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)http.httpURL(), HTTPURL_BINDING);
            protocolMarshaller.marshall((Object)http.httpStatus(), HTTPSTATUS_BINDING);
            protocolMarshaller.marshall((Object)http.httpMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall((Object)http.userAgent(), USERAGENT_BINDING);
            protocolMarshaller.marshall((Object)http.clientIp(), CLIENTIP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

