/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.ServiceStatistics;
import software.amazon.awssdk.services.xray.transform.ErrorStatisticsUnmarshaller;
import software.amazon.awssdk.services.xray.transform.FaultStatisticsUnmarshaller;

public class ServiceStatisticsUnmarshaller
implements Unmarshaller<ServiceStatistics, JsonUnmarshallerContext> {
    private static final ServiceStatisticsUnmarshaller INSTANCE = new ServiceStatisticsUnmarshaller();

    public ServiceStatistics unmarshall(JsonUnmarshallerContext context) throws Exception {
        ServiceStatistics.Builder serviceStatisticsBuilder = ServiceStatistics.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("OkCount", targetDepth)) {
                    context.nextToken();
                    serviceStatisticsBuilder.okCount((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("ErrorStatistics", targetDepth)) {
                    context.nextToken();
                    serviceStatisticsBuilder.errorStatistics(ErrorStatisticsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("FaultStatistics", targetDepth)) {
                    context.nextToken();
                    serviceStatisticsBuilder.faultStatistics(FaultStatisticsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("TotalCount", targetDepth)) {
                    context.nextToken();
                    serviceStatisticsBuilder.totalCount((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("TotalResponseTime", targetDepth)) {
                    context.nextToken();
                    serviceStatisticsBuilder.totalResponseTime((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ServiceStatistics)serviceStatisticsBuilder.build();
    }

    public static ServiceStatisticsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

