/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.xray.model.TelemetryRecord;
import software.amazon.awssdk.services.xray.model.TelemetryRecordListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutTelemetryRecordsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutTelemetryRecordsRequest> {
    private final List<TelemetryRecord> telemetryRecords;
    private final String ec2InstanceId;
    private final String hostname;
    private final String resourceARN;

    private PutTelemetryRecordsRequest(BuilderImpl builder) {
        this.telemetryRecords = builder.telemetryRecords;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.hostname = builder.hostname;
        this.resourceARN = builder.resourceARN;
    }

    public List<TelemetryRecord> telemetryRecords() {
        return this.telemetryRecords;
    }

    public String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public String hostname() {
        return this.hostname;
    }

    public String resourceARN() {
        return this.resourceARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.telemetryRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTelemetryRecordsRequest)) {
            return false;
        }
        PutTelemetryRecordsRequest other = (PutTelemetryRecordsRequest)((Object)obj);
        return Objects.equals(this.telemetryRecords(), other.telemetryRecords()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.resourceARN(), other.resourceARN());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.telemetryRecords() != null) {
            sb.append("TelemetryRecords: ").append(this.telemetryRecords()).append(",");
        }
        if (this.ec2InstanceId() != null) {
            sb.append("EC2InstanceId: ").append(this.ec2InstanceId()).append(",");
        }
        if (this.hostname() != null) {
            sb.append("Hostname: ").append(this.hostname()).append(",");
        }
        if (this.resourceARN() != null) {
            sb.append("ResourceARN: ").append(this.resourceARN()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TelemetryRecords": {
                return Optional.of(clazz.cast(this.telemetryRecords()));
            }
            case "EC2InstanceId": {
                return Optional.of(clazz.cast(this.ec2InstanceId()));
            }
            case "Hostname": {
                return Optional.of(clazz.cast(this.hostname()));
            }
            case "ResourceARN": {
                return Optional.of(clazz.cast(this.resourceARN()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<TelemetryRecord> telemetryRecords;
        private String ec2InstanceId;
        private String hostname;
        private String resourceARN;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTelemetryRecordsRequest model) {
            this.telemetryRecords(model.telemetryRecords);
            this.ec2InstanceId(model.ec2InstanceId);
            this.hostname(model.hostname);
            this.resourceARN(model.resourceARN);
        }

        public final Collection<TelemetryRecord.Builder> getTelemetryRecords() {
            return this.telemetryRecords != null ? (Collection)this.telemetryRecords.stream().map(TelemetryRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder telemetryRecords(Collection<TelemetryRecord> telemetryRecords) {
            this.telemetryRecords = TelemetryRecordListCopier.copy(telemetryRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryRecords(TelemetryRecord ... telemetryRecords) {
            this.telemetryRecords(Arrays.asList(telemetryRecords));
            return this;
        }

        public final void setTelemetryRecords(Collection<TelemetryRecord.BuilderImpl> telemetryRecords) {
            this.telemetryRecords = TelemetryRecordListCopier.copyFromBuilder(telemetryRecords);
        }

        public final String getEC2InstanceId() {
            return this.ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final void setEC2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public PutTelemetryRecordsRequest build() {
            return new PutTelemetryRecordsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutTelemetryRecordsRequest> {
        public Builder telemetryRecords(Collection<TelemetryRecord> var1);

        public Builder telemetryRecords(TelemetryRecord ... var1);

        public Builder ec2InstanceId(String var1);

        public Builder hostname(String var1);

        public Builder resourceARN(String var1);
    }
}

