/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.Trace;
import software.amazon.awssdk.services.xray.transform.SegmentUnmarshaller;

public class TraceUnmarshaller
implements Unmarshaller<Trace, JsonUnmarshallerContext> {
    private static final TraceUnmarshaller INSTANCE = new TraceUnmarshaller();

    public Trace unmarshall(JsonUnmarshallerContext context) throws Exception {
        Trace.Builder traceBuilder = Trace.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    traceBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Duration", targetDepth)) {
                    context.nextToken();
                    traceBuilder.duration((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("Segments", targetDepth)) {
                    context.nextToken();
                    traceBuilder.segments(new ListUnmarshaller((Unmarshaller)SegmentUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Trace)traceBuilder.build();
    }

    public static TraceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

