/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.BackendConnectionErrors;

public class BackendConnectionErrorsUnmarshaller
implements Unmarshaller<BackendConnectionErrors, JsonUnmarshallerContext> {
    private static final BackendConnectionErrorsUnmarshaller INSTANCE = new BackendConnectionErrorsUnmarshaller();

    public BackendConnectionErrors unmarshall(JsonUnmarshallerContext context) throws Exception {
        BackendConnectionErrors.Builder backendConnectionErrorsBuilder = BackendConnectionErrors.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TimeoutCount", targetDepth)) {
                    context.nextToken();
                    backendConnectionErrorsBuilder.timeoutCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("ConnectionRefusedCount", targetDepth)) {
                    context.nextToken();
                    backendConnectionErrorsBuilder.connectionRefusedCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("HTTPCode4XXCount", targetDepth)) {
                    context.nextToken();
                    backendConnectionErrorsBuilder.httpCode4XXCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("HTTPCode5XXCount", targetDepth)) {
                    context.nextToken();
                    backendConnectionErrorsBuilder.httpCode5XXCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("UnknownHostCount", targetDepth)) {
                    context.nextToken();
                    backendConnectionErrorsBuilder.unknownHostCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("OtherCount", targetDepth)) {
                    context.nextToken();
                    backendConnectionErrorsBuilder.otherCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (BackendConnectionErrors)backendConnectionErrorsBuilder.build();
    }

    public static BackendConnectionErrorsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

