/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.FaultStatistics;

@SdkInternalApi
public class FaultStatisticsMarshaller {
    private static final MarshallingInfo<Long> OTHERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OtherCount").build();
    private static final MarshallingInfo<Long> TOTALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalCount").build();
    private static final FaultStatisticsMarshaller instance = new FaultStatisticsMarshaller();

    public static FaultStatisticsMarshaller getInstance() {
        return instance;
    }

    public void marshall(FaultStatistics faultStatistics, ProtocolMarshaller protocolMarshaller) {
        if (faultStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)faultStatistics.otherCount(), OTHERCOUNT_BINDING);
            protocolMarshaller.marshall((Object)faultStatistics.totalCount(), TOTALCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

