/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.AnnotationValue;
import software.amazon.awssdk.services.xray.model.ServiceId;
import software.amazon.awssdk.services.xray.model.ServiceIdsCopier;
import software.amazon.awssdk.services.xray.transform.ValueWithServiceIdsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValueWithServiceIds
implements StructuredPojo,
ToCopyableBuilder<Builder, ValueWithServiceIds> {
    private final AnnotationValue annotationValue;
    private final List<ServiceId> serviceIds;

    private ValueWithServiceIds(BuilderImpl builder) {
        this.annotationValue = builder.annotationValue;
        this.serviceIds = builder.serviceIds;
    }

    public AnnotationValue annotationValue() {
        return this.annotationValue;
    }

    public List<ServiceId> serviceIds() {
        return this.serviceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.annotationValue() == null ? 0 : this.annotationValue().hashCode());
        hashCode = 31 * hashCode + (this.serviceIds() == null ? 0 : this.serviceIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValueWithServiceIds)) {
            return false;
        }
        ValueWithServiceIds other = (ValueWithServiceIds)obj;
        if (other.annotationValue() == null ^ this.annotationValue() == null) {
            return false;
        }
        if (other.annotationValue() != null && !other.annotationValue().equals(this.annotationValue())) {
            return false;
        }
        if (other.serviceIds() == null ^ this.serviceIds() == null) {
            return false;
        }
        return other.serviceIds() == null || other.serviceIds().equals(this.serviceIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotationValue() != null) {
            sb.append("AnnotationValue: ").append(this.annotationValue()).append(",");
        }
        if (this.serviceIds() != null) {
            sb.append("ServiceIds: ").append(this.serviceIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ValueWithServiceIdsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private AnnotationValue annotationValue;
        private List<ServiceId> serviceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ValueWithServiceIds model) {
            this.setAnnotationValue(model.annotationValue);
            this.setServiceIds(model.serviceIds);
        }

        public final AnnotationValue getAnnotationValue() {
            return this.annotationValue;
        }

        @Override
        public final Builder annotationValue(AnnotationValue annotationValue) {
            this.annotationValue = annotationValue;
            return this;
        }

        public final void setAnnotationValue(AnnotationValue annotationValue) {
            this.annotationValue = annotationValue;
        }

        public final Collection<ServiceId> getServiceIds() {
            return this.serviceIds;
        }

        @Override
        public final Builder serviceIds(Collection<ServiceId> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copy(serviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(ServiceId ... serviceIds) {
            this.serviceIds(Arrays.asList(serviceIds));
            return this;
        }

        public final void setServiceIds(Collection<ServiceId> serviceIds) {
            this.serviceIds = ServiceIdsCopier.copy(serviceIds);
        }

        @SafeVarargs
        public final void setServiceIds(ServiceId ... serviceIds) {
            this.serviceIds(Arrays.asList(serviceIds));
        }

        public ValueWithServiceIds build() {
            return new ValueWithServiceIds(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValueWithServiceIds> {
        public Builder annotationValue(AnnotationValue var1);

        public Builder serviceIds(Collection<ServiceId> var1);

        public Builder serviceIds(ServiceId ... var1);
    }
}

