/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.Segment;
import software.amazon.awssdk.services.xray.model.SegmentListCopier;
import software.amazon.awssdk.services.xray.transform.TraceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Trace
implements StructuredPojo,
ToCopyableBuilder<Builder, Trace> {
    private final String id;
    private final Double duration;
    private final List<Segment> segments;

    private Trace(BuilderImpl builder) {
        this.id = builder.id;
        this.duration = builder.duration;
        this.segments = builder.segments;
    }

    public String id() {
        return this.id;
    }

    public Double duration() {
        return this.duration;
    }

    public List<Segment> segments() {
        return this.segments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.duration() == null ? 0 : this.duration().hashCode());
        hashCode = 31 * hashCode + (this.segments() == null ? 0 : this.segments().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trace)) {
            return false;
        }
        Trace other = (Trace)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.segments() == null ^ this.segments() == null) {
            return false;
        }
        return other.segments() == null || other.segments().equals(this.segments());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.segments() != null) {
            sb.append("Segments: ").append(this.segments()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TraceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private Double duration;
        private List<Segment> segments;

        private BuilderImpl() {
        }

        private BuilderImpl(Trace model) {
            this.setId(model.id);
            this.setDuration(model.duration);
            this.setSegments(model.segments);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Double getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Double duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Double duration) {
            this.duration = duration;
        }

        public final Collection<Segment> getSegments() {
            return this.segments;
        }

        @Override
        public final Builder segments(Collection<Segment> segments) {
            this.segments = SegmentListCopier.copy(segments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segments(Segment ... segments) {
            this.segments(Arrays.asList(segments));
            return this;
        }

        public final void setSegments(Collection<Segment> segments) {
            this.segments = SegmentListCopier.copy(segments);
        }

        @SafeVarargs
        public final void setSegments(Segment ... segments) {
            this.segments(Arrays.asList(segments));
        }

        public Trace build() {
            return new Trace(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Trace> {
        public Builder id(String var1);

        public Builder duration(Double var1);

        public Builder segments(Collection<Segment> var1);

        public Builder segments(Segment ... var1);
    }
}

