/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.BackendConnectionErrors;
import software.amazon.awssdk.services.xray.transform.TelemetryRecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TelemetryRecord
implements StructuredPojo,
ToCopyableBuilder<Builder, TelemetryRecord> {
    private final Instant timestamp;
    private final Integer segmentsReceivedCount;
    private final Integer segmentsSentCount;
    private final Integer segmentsSpilloverCount;
    private final Integer segmentsRejectedCount;
    private final BackendConnectionErrors backendConnectionErrors;

    private TelemetryRecord(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.segmentsReceivedCount = builder.segmentsReceivedCount;
        this.segmentsSentCount = builder.segmentsSentCount;
        this.segmentsSpilloverCount = builder.segmentsSpilloverCount;
        this.segmentsRejectedCount = builder.segmentsRejectedCount;
        this.backendConnectionErrors = builder.backendConnectionErrors;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Integer segmentsReceivedCount() {
        return this.segmentsReceivedCount;
    }

    public Integer segmentsSentCount() {
        return this.segmentsSentCount;
    }

    public Integer segmentsSpilloverCount() {
        return this.segmentsSpilloverCount;
    }

    public Integer segmentsRejectedCount() {
        return this.segmentsRejectedCount;
    }

    public BackendConnectionErrors backendConnectionErrors() {
        return this.backendConnectionErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.timestamp() == null ? 0 : this.timestamp().hashCode());
        hashCode = 31 * hashCode + (this.segmentsReceivedCount() == null ? 0 : this.segmentsReceivedCount().hashCode());
        hashCode = 31 * hashCode + (this.segmentsSentCount() == null ? 0 : this.segmentsSentCount().hashCode());
        hashCode = 31 * hashCode + (this.segmentsSpilloverCount() == null ? 0 : this.segmentsSpilloverCount().hashCode());
        hashCode = 31 * hashCode + (this.segmentsRejectedCount() == null ? 0 : this.segmentsRejectedCount().hashCode());
        hashCode = 31 * hashCode + (this.backendConnectionErrors() == null ? 0 : this.backendConnectionErrors().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryRecord)) {
            return false;
        }
        TelemetryRecord other = (TelemetryRecord)obj;
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.segmentsReceivedCount() == null ^ this.segmentsReceivedCount() == null) {
            return false;
        }
        if (other.segmentsReceivedCount() != null && !other.segmentsReceivedCount().equals(this.segmentsReceivedCount())) {
            return false;
        }
        if (other.segmentsSentCount() == null ^ this.segmentsSentCount() == null) {
            return false;
        }
        if (other.segmentsSentCount() != null && !other.segmentsSentCount().equals(this.segmentsSentCount())) {
            return false;
        }
        if (other.segmentsSpilloverCount() == null ^ this.segmentsSpilloverCount() == null) {
            return false;
        }
        if (other.segmentsSpilloverCount() != null && !other.segmentsSpilloverCount().equals(this.segmentsSpilloverCount())) {
            return false;
        }
        if (other.segmentsRejectedCount() == null ^ this.segmentsRejectedCount() == null) {
            return false;
        }
        if (other.segmentsRejectedCount() != null && !other.segmentsRejectedCount().equals(this.segmentsRejectedCount())) {
            return false;
        }
        if (other.backendConnectionErrors() == null ^ this.backendConnectionErrors() == null) {
            return false;
        }
        return other.backendConnectionErrors() == null || other.backendConnectionErrors().equals(this.backendConnectionErrors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        if (this.segmentsReceivedCount() != null) {
            sb.append("SegmentsReceivedCount: ").append(this.segmentsReceivedCount()).append(",");
        }
        if (this.segmentsSentCount() != null) {
            sb.append("SegmentsSentCount: ").append(this.segmentsSentCount()).append(",");
        }
        if (this.segmentsSpilloverCount() != null) {
            sb.append("SegmentsSpilloverCount: ").append(this.segmentsSpilloverCount()).append(",");
        }
        if (this.segmentsRejectedCount() != null) {
            sb.append("SegmentsRejectedCount: ").append(this.segmentsRejectedCount()).append(",");
        }
        if (this.backendConnectionErrors() != null) {
            sb.append("BackendConnectionErrors: ").append(this.backendConnectionErrors()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TelemetryRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private Integer segmentsReceivedCount;
        private Integer segmentsSentCount;
        private Integer segmentsSpilloverCount;
        private Integer segmentsRejectedCount;
        private BackendConnectionErrors backendConnectionErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryRecord model) {
            this.setTimestamp(model.timestamp);
            this.setSegmentsReceivedCount(model.segmentsReceivedCount);
            this.setSegmentsSentCount(model.segmentsSentCount);
            this.setSegmentsSpilloverCount(model.segmentsSpilloverCount);
            this.setSegmentsRejectedCount(model.segmentsRejectedCount);
            this.setBackendConnectionErrors(model.backendConnectionErrors);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Integer getSegmentsReceivedCount() {
            return this.segmentsReceivedCount;
        }

        @Override
        public final Builder segmentsReceivedCount(Integer segmentsReceivedCount) {
            this.segmentsReceivedCount = segmentsReceivedCount;
            return this;
        }

        public final void setSegmentsReceivedCount(Integer segmentsReceivedCount) {
            this.segmentsReceivedCount = segmentsReceivedCount;
        }

        public final Integer getSegmentsSentCount() {
            return this.segmentsSentCount;
        }

        @Override
        public final Builder segmentsSentCount(Integer segmentsSentCount) {
            this.segmentsSentCount = segmentsSentCount;
            return this;
        }

        public final void setSegmentsSentCount(Integer segmentsSentCount) {
            this.segmentsSentCount = segmentsSentCount;
        }

        public final Integer getSegmentsSpilloverCount() {
            return this.segmentsSpilloverCount;
        }

        @Override
        public final Builder segmentsSpilloverCount(Integer segmentsSpilloverCount) {
            this.segmentsSpilloverCount = segmentsSpilloverCount;
            return this;
        }

        public final void setSegmentsSpilloverCount(Integer segmentsSpilloverCount) {
            this.segmentsSpilloverCount = segmentsSpilloverCount;
        }

        public final Integer getSegmentsRejectedCount() {
            return this.segmentsRejectedCount;
        }

        @Override
        public final Builder segmentsRejectedCount(Integer segmentsRejectedCount) {
            this.segmentsRejectedCount = segmentsRejectedCount;
            return this;
        }

        public final void setSegmentsRejectedCount(Integer segmentsRejectedCount) {
            this.segmentsRejectedCount = segmentsRejectedCount;
        }

        public final BackendConnectionErrors getBackendConnectionErrors() {
            return this.backendConnectionErrors;
        }

        @Override
        public final Builder backendConnectionErrors(BackendConnectionErrors backendConnectionErrors) {
            this.backendConnectionErrors = backendConnectionErrors;
            return this;
        }

        public final void setBackendConnectionErrors(BackendConnectionErrors backendConnectionErrors) {
            this.backendConnectionErrors = backendConnectionErrors;
        }

        public TelemetryRecord build() {
            return new TelemetryRecord(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TelemetryRecord> {
        public Builder timestamp(Instant var1);

        public Builder segmentsReceivedCount(Integer var1);

        public Builder segmentsSentCount(Integer var1);

        public Builder segmentsSpilloverCount(Integer var1);

        public Builder segmentsRejectedCount(Integer var1);

        public Builder backendConnectionErrors(BackendConnectionErrors var1);
    }
}

