/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.UnprocessedTraceSegment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UnprocessedTraceSegmentMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();
    private static final UnprocessedTraceSegmentMarshaller INSTANCE = new UnprocessedTraceSegmentMarshaller();

    private UnprocessedTraceSegmentMarshaller() {
    }

    public static UnprocessedTraceSegmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UnprocessedTraceSegment unprocessedTraceSegment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)unprocessedTraceSegment, (String)"unprocessedTraceSegment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)unprocessedTraceSegment.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)unprocessedTraceSegment.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)unprocessedTraceSegment.message(), MESSAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

