/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.UnprocessedStatistics;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UnprocessedStatisticsMarshaller {
    private static final MarshallingInfo<String> RULENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleName").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").isBinary(false).build();
    private static final UnprocessedStatisticsMarshaller INSTANCE = new UnprocessedStatisticsMarshaller();

    private UnprocessedStatisticsMarshaller() {
    }

    public static UnprocessedStatisticsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UnprocessedStatistics unprocessedStatistics, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)unprocessedStatistics, (String)"unprocessedStatistics");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)unprocessedStatistics.ruleName(), RULENAME_BINDING);
            protocolMarshaller.marshall((Object)unprocessedStatistics.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)unprocessedStatistics.message(), MESSAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

