/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.SamplingTargetDocument;

public class SamplingTargetDocumentUnmarshaller
implements Unmarshaller<SamplingTargetDocument, JsonUnmarshallerContext> {
    private static final SamplingTargetDocumentUnmarshaller INSTANCE = new SamplingTargetDocumentUnmarshaller();

    public SamplingTargetDocument unmarshall(JsonUnmarshallerContext context) throws Exception {
        SamplingTargetDocument.Builder samplingTargetDocumentBuilder = SamplingTargetDocument.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("RuleName", targetDepth)) {
                    context.nextToken();
                    samplingTargetDocumentBuilder.ruleName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FixedRate", targetDepth)) {
                    context.nextToken();
                    samplingTargetDocumentBuilder.fixedRate((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("ReservoirQuota", targetDepth)) {
                    context.nextToken();
                    samplingTargetDocumentBuilder.reservoirQuota((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("ReservoirQuotaTTL", targetDepth)) {
                    context.nextToken();
                    samplingTargetDocumentBuilder.reservoirQuotaTTL((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Interval", targetDepth)) {
                    context.nextToken();
                    samplingTargetDocumentBuilder.interval((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SamplingTargetDocument)samplingTargetDocumentBuilder.build();
    }

    public static SamplingTargetDocumentUnmarshaller getInstance() {
        return INSTANCE;
    }
}

