/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.SamplingStatisticSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SamplingStatisticSummaryMarshaller {
    private static final MarshallingInfo<String> RULENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleName").isBinary(false).build();
    private static final MarshallingInfo<Instant> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").isBinary(false).build();
    private static final MarshallingInfo<Integer> REQUESTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> BORROWCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BorrowCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> SAMPLEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SampledCount").isBinary(false).build();
    private static final SamplingStatisticSummaryMarshaller INSTANCE = new SamplingStatisticSummaryMarshaller();

    private SamplingStatisticSummaryMarshaller() {
    }

    public static SamplingStatisticSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SamplingStatisticSummary samplingStatisticSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)samplingStatisticSummary, (String)"samplingStatisticSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)samplingStatisticSummary.ruleName(), RULENAME_BINDING);
            protocolMarshaller.marshall((Object)samplingStatisticSummary.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)samplingStatisticSummary.requestCount(), REQUESTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)samplingStatisticSummary.borrowCount(), BORROWCOUNT_BINDING);
            protocolMarshaller.marshall((Object)samplingStatisticSummary.sampledCount(), SAMPLEDCOUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

