/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.SamplingRuleRecord;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SamplingRuleRecordMarshaller {
    private static final MarshallingInfo<StructuredPojo> SAMPLINGRULE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SamplingRule").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").isBinary(false).build();
    private static final MarshallingInfo<Instant> MODIFIEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModifiedAt").isBinary(false).build();
    private static final SamplingRuleRecordMarshaller INSTANCE = new SamplingRuleRecordMarshaller();

    private SamplingRuleRecordMarshaller() {
    }

    public static SamplingRuleRecordMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SamplingRuleRecord samplingRuleRecord, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)samplingRuleRecord, (String)"samplingRuleRecord");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)samplingRuleRecord.samplingRule(), SAMPLINGRULE_BINDING);
            protocolMarshaller.marshall((Object)samplingRuleRecord.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)samplingRuleRecord.modifiedAt(), MODIFIEDAT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

