/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.PutEncryptionConfigRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutEncryptionConfigRequestModelMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final PutEncryptionConfigRequestModelMarshaller INSTANCE = new PutEncryptionConfigRequestModelMarshaller();

    private PutEncryptionConfigRequestModelMarshaller() {
    }

    public static PutEncryptionConfigRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutEncryptionConfigRequest putEncryptionConfigRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)putEncryptionConfigRequest), (String)"putEncryptionConfigRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putEncryptionConfigRequest.keyId(), KEYID_BINDING);
            protocolMarshaller.marshall((Object)putEncryptionConfigRequest.typeAsString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

