/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.xray.model.EdgeStatistics;
import software.amazon.awssdk.services.xray.transform.ErrorStatisticsUnmarshaller;
import software.amazon.awssdk.services.xray.transform.FaultStatisticsUnmarshaller;

public class EdgeStatisticsUnmarshaller
implements Unmarshaller<EdgeStatistics, JsonUnmarshallerContext> {
    private static final EdgeStatisticsUnmarshaller INSTANCE = new EdgeStatisticsUnmarshaller();

    public EdgeStatistics unmarshall(JsonUnmarshallerContext context) throws Exception {
        EdgeStatistics.Builder edgeStatisticsBuilder = EdgeStatistics.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("OkCount", targetDepth)) {
                    context.nextToken();
                    edgeStatisticsBuilder.okCount((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("ErrorStatistics", targetDepth)) {
                    context.nextToken();
                    edgeStatisticsBuilder.errorStatistics(ErrorStatisticsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("FaultStatistics", targetDepth)) {
                    context.nextToken();
                    edgeStatisticsBuilder.faultStatistics(FaultStatisticsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("TotalCount", targetDepth)) {
                    context.nextToken();
                    edgeStatisticsBuilder.totalCount((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("TotalResponseTime", targetDepth)) {
                    context.nextToken();
                    edgeStatisticsBuilder.totalResponseTime((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EdgeStatistics)edgeStatisticsBuilder.build();
    }

    public static EdgeStatisticsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

