/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.transform.SamplingTargetDocumentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SamplingTargetDocument
implements StructuredPojo,
ToCopyableBuilder<Builder, SamplingTargetDocument> {
    private final String ruleName;
    private final Double fixedRate;
    private final Integer reservoirQuota;
    private final Instant reservoirQuotaTTL;
    private final Integer interval;

    private SamplingTargetDocument(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.fixedRate = builder.fixedRate;
        this.reservoirQuota = builder.reservoirQuota;
        this.reservoirQuotaTTL = builder.reservoirQuotaTTL;
        this.interval = builder.interval;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public Double fixedRate() {
        return this.fixedRate;
    }

    public Integer reservoirQuota() {
        return this.reservoirQuota;
    }

    public Instant reservoirQuotaTTL() {
        return this.reservoirQuotaTTL;
    }

    public Integer interval() {
        return this.interval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservoirQuota());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservoirQuotaTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingTargetDocument)) {
            return false;
        }
        SamplingTargetDocument other = (SamplingTargetDocument)obj;
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.fixedRate(), other.fixedRate()) && Objects.equals(this.reservoirQuota(), other.reservoirQuota()) && Objects.equals(this.reservoirQuotaTTL(), other.reservoirQuotaTTL()) && Objects.equals(this.interval(), other.interval());
    }

    public String toString() {
        return ToString.builder((String)"SamplingTargetDocument").add("RuleName", (Object)this.ruleName()).add("FixedRate", (Object)this.fixedRate()).add("ReservoirQuota", (Object)this.reservoirQuota()).add("ReservoirQuotaTTL", (Object)this.reservoirQuotaTTL()).add("Interval", (Object)this.interval()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "FixedRate": {
                return Optional.ofNullable(clazz.cast(this.fixedRate()));
            }
            case "ReservoirQuota": {
                return Optional.ofNullable(clazz.cast(this.reservoirQuota()));
            }
            case "ReservoirQuotaTTL": {
                return Optional.ofNullable(clazz.cast(this.reservoirQuotaTTL()));
            }
            case "Interval": {
                return Optional.ofNullable(clazz.cast(this.interval()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SamplingTargetDocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleName;
        private Double fixedRate;
        private Integer reservoirQuota;
        private Instant reservoirQuotaTTL;
        private Integer interval;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingTargetDocument model) {
            this.ruleName(model.ruleName);
            this.fixedRate(model.fixedRate);
            this.reservoirQuota(model.reservoirQuota);
            this.reservoirQuotaTTL(model.reservoirQuotaTTL);
            this.interval(model.interval);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final Double getFixedRate() {
            return this.fixedRate;
        }

        @Override
        public final Builder fixedRate(Double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public final void setFixedRate(Double fixedRate) {
            this.fixedRate = fixedRate;
        }

        public final Integer getReservoirQuota() {
            return this.reservoirQuota;
        }

        @Override
        public final Builder reservoirQuota(Integer reservoirQuota) {
            this.reservoirQuota = reservoirQuota;
            return this;
        }

        public final void setReservoirQuota(Integer reservoirQuota) {
            this.reservoirQuota = reservoirQuota;
        }

        public final Instant getReservoirQuotaTTL() {
            return this.reservoirQuotaTTL;
        }

        @Override
        public final Builder reservoirQuotaTTL(Instant reservoirQuotaTTL) {
            this.reservoirQuotaTTL = reservoirQuotaTTL;
            return this;
        }

        public final void setReservoirQuotaTTL(Instant reservoirQuotaTTL) {
            this.reservoirQuotaTTL = reservoirQuotaTTL;
        }

        public final Integer getInterval() {
            return this.interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        public SamplingTargetDocument build() {
            return new SamplingTargetDocument(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SamplingTargetDocument> {
        public Builder ruleName(String var1);

        public Builder fixedRate(Double var1);

        public Builder reservoirQuota(Integer var1);

        public Builder reservoirQuotaTTL(Instant var1);

        public Builder interval(Integer var1);
    }
}

