/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.xray.model.AttributeMapCopier;
import software.amazon.awssdk.services.xray.transform.SamplingRuleUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SamplingRuleUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, SamplingRuleUpdate> {
    private final String ruleName;
    private final String ruleARN;
    private final String resourceARN;
    private final Integer priority;
    private final Double fixedRate;
    private final Integer reservoirSize;
    private final String host;
    private final String serviceName;
    private final String serviceType;
    private final String httpMethod;
    private final String urlPath;
    private final Map<String, String> attributes;

    private SamplingRuleUpdate(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.ruleARN = builder.ruleARN;
        this.resourceARN = builder.resourceARN;
        this.priority = builder.priority;
        this.fixedRate = builder.fixedRate;
        this.reservoirSize = builder.reservoirSize;
        this.host = builder.host;
        this.serviceName = builder.serviceName;
        this.serviceType = builder.serviceType;
        this.httpMethod = builder.httpMethod;
        this.urlPath = builder.urlPath;
        this.attributes = builder.attributes;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public String ruleARN() {
        return this.ruleARN;
    }

    public String resourceARN() {
        return this.resourceARN;
    }

    public Integer priority() {
        return this.priority;
    }

    public Double fixedRate() {
        return this.fixedRate;
    }

    public Integer reservoirSize() {
        return this.reservoirSize;
    }

    public String host() {
        return this.host;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String serviceType() {
        return this.serviceType;
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public String urlPath() {
        return this.urlPath;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservoirSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingRuleUpdate)) {
            return false;
        }
        SamplingRuleUpdate other = (SamplingRuleUpdate)obj;
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.ruleARN(), other.ruleARN()) && Objects.equals(this.resourceARN(), other.resourceARN()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.fixedRate(), other.fixedRate()) && Objects.equals(this.reservoirSize(), other.reservoirSize()) && Objects.equals(this.host(), other.host()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceType(), other.serviceType()) && Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.urlPath(), other.urlPath()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"SamplingRuleUpdate").add("RuleName", (Object)this.ruleName()).add("RuleARN", (Object)this.ruleARN()).add("ResourceARN", (Object)this.resourceARN()).add("Priority", (Object)this.priority()).add("FixedRate", (Object)this.fixedRate()).add("ReservoirSize", (Object)this.reservoirSize()).add("Host", (Object)this.host()).add("ServiceName", (Object)this.serviceName()).add("ServiceType", (Object)this.serviceType()).add("HTTPMethod", (Object)this.httpMethod()).add("URLPath", (Object)this.urlPath()).add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "RuleARN": {
                return Optional.ofNullable(clazz.cast(this.ruleARN()));
            }
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "FixedRate": {
                return Optional.ofNullable(clazz.cast(this.fixedRate()));
            }
            case "ReservoirSize": {
                return Optional.ofNullable(clazz.cast(this.reservoirSize()));
            }
            case "Host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceType()));
            }
            case "HTTPMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "URLPath": {
                return Optional.ofNullable(clazz.cast(this.urlPath()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SamplingRuleUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleName;
        private String ruleARN;
        private String resourceARN;
        private Integer priority;
        private Double fixedRate;
        private Integer reservoirSize;
        private String host;
        private String serviceName;
        private String serviceType;
        private String httpMethod;
        private String urlPath;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingRuleUpdate model) {
            this.ruleName(model.ruleName);
            this.ruleARN(model.ruleARN);
            this.resourceARN(model.resourceARN);
            this.priority(model.priority);
            this.fixedRate(model.fixedRate);
            this.reservoirSize(model.reservoirSize);
            this.host(model.host);
            this.serviceName(model.serviceName);
            this.serviceType(model.serviceType);
            this.httpMethod(model.httpMethod);
            this.urlPath(model.urlPath);
            this.attributes(model.attributes);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getRuleARN() {
            return this.ruleARN;
        }

        @Override
        public final Builder ruleARN(String ruleARN) {
            this.ruleARN = ruleARN;
            return this;
        }

        public final void setRuleARN(String ruleARN) {
            this.ruleARN = ruleARN;
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Double getFixedRate() {
            return this.fixedRate;
        }

        @Override
        public final Builder fixedRate(Double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public final void setFixedRate(Double fixedRate) {
            this.fixedRate = fixedRate;
        }

        public final Integer getReservoirSize() {
            return this.reservoirSize;
        }

        @Override
        public final Builder reservoirSize(Integer reservoirSize) {
            this.reservoirSize = reservoirSize;
            return this;
        }

        public final void setReservoirSize(Integer reservoirSize) {
            this.reservoirSize = reservoirSize;
        }

        public final String getHost() {
            return this.host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getServiceType() {
            return this.serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public final String getHTTPMethod() {
            return this.httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHTTPMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final String getURLPath() {
            return this.urlPath;
        }

        @Override
        public final Builder urlPath(String urlPath) {
            this.urlPath = urlPath;
            return this;
        }

        public final void setURLPath(String urlPath) {
            this.urlPath = urlPath;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributeMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributeMapCopier.copy(attributes);
        }

        public SamplingRuleUpdate build() {
            return new SamplingRuleUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SamplingRuleUpdate> {
        public Builder ruleName(String var1);

        public Builder ruleARN(String var1);

        public Builder resourceARN(String var1);

        public Builder priority(Integer var1);

        public Builder fixedRate(Double var1);

        public Builder reservoirSize(Integer var1);

        public Builder host(String var1);

        public Builder serviceName(String var1);

        public Builder serviceType(String var1);

        public Builder httpMethod(String var1);

        public Builder urlPath(String var1);

        public Builder attributes(Map<String, String> var1);
    }
}

