/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.Service;
import software.amazon.awssdk.services.xray.model.ServiceListCopier;
import software.amazon.awssdk.services.xray.model.XRayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTraceGraphResponse
extends XRayResponse
implements ToCopyableBuilder<Builder, GetTraceGraphResponse> {
    private final List<Service> services;
    private final String nextToken;

    private GetTraceGraphResponse(BuilderImpl builder) {
        super(builder);
        this.services = builder.services;
        this.nextToken = builder.nextToken;
    }

    public List<Service> services() {
        return this.services;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.services());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTraceGraphResponse)) {
            return false;
        }
        GetTraceGraphResponse other = (GetTraceGraphResponse)((Object)obj);
        return Objects.equals(this.services(), other.services()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetTraceGraphResponse").add("Services", this.services()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends XRayResponse.BuilderImpl
    implements Builder {
        private List<Service> services = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTraceGraphResponse model) {
            super(model);
            this.services(model.services);
            this.nextToken(model.nextToken);
        }

        public final Collection<Service.Builder> getServices() {
            return this.services != null ? (Collection)this.services.stream().map(Service::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder services(Collection<Service> services) {
            this.services = ServiceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Service ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<Service.Builder> ... services) {
            this.services(Stream.of(services).map(c -> (Service)((Service.Builder)Service.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServices(Collection<Service.BuilderImpl> services) {
            this.services = ServiceListCopier.copyFromBuilder(services);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetTraceGraphResponse build() {
            return new GetTraceGraphResponse(this);
        }
    }

    public static interface Builder
    extends XRayResponse.Builder,
    CopyableBuilder<Builder, GetTraceGraphResponse> {
        public Builder services(Collection<Service> var1);

        public Builder services(Service ... var1);

        public Builder services(Consumer<Service.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

