/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.TraceIdListCopier;
import software.amazon.awssdk.services.xray.model.XRayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetTracesRequest
extends XRayRequest
implements ToCopyableBuilder<Builder, BatchGetTracesRequest> {
    private final List<String> traceIds;
    private final String nextToken;

    private BatchGetTracesRequest(BuilderImpl builder) {
        super(builder);
        this.traceIds = builder.traceIds;
        this.nextToken = builder.nextToken;
    }

    public List<String> traceIds() {
        return this.traceIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.traceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTracesRequest)) {
            return false;
        }
        BatchGetTracesRequest other = (BatchGetTracesRequest)((Object)obj);
        return Objects.equals(this.traceIds(), other.traceIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetTracesRequest").add("TraceIds", this.traceIds()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TraceIds": {
                return Optional.ofNullable(clazz.cast(this.traceIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends XRayRequest.BuilderImpl
    implements Builder {
        private List<String> traceIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTracesRequest model) {
            super(model);
            this.traceIds(model.traceIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getTraceIds() {
            return this.traceIds;
        }

        @Override
        public final Builder traceIds(Collection<String> traceIds) {
            this.traceIds = TraceIdListCopier.copy(traceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder traceIds(String ... traceIds) {
            this.traceIds(Arrays.asList(traceIds));
            return this;
        }

        public final void setTraceIds(Collection<String> traceIds) {
            this.traceIds = TraceIdListCopier.copy(traceIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetTracesRequest build() {
            return new BatchGetTracesRequest(this);
        }
    }

    public static interface Builder
    extends XRayRequest.Builder,
    CopyableBuilder<Builder, BatchGetTracesRequest> {
        public Builder traceIds(Collection<String> var1);

        public Builder traceIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

