/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.TelemetryRecord;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TelemetryRecordMarshaller {
    private static final MarshallingInfo<Instant> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").isBinary(false).build();
    private static final MarshallingInfo<Integer> SEGMENTSRECEIVEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentsReceivedCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> SEGMENTSSENTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentsSentCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> SEGMENTSSPILLOVERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentsSpilloverCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> SEGMENTSREJECTEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentsRejectedCount").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> BACKENDCONNECTIONERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackendConnectionErrors").isBinary(false).build();
    private static final TelemetryRecordMarshaller INSTANCE = new TelemetryRecordMarshaller();

    private TelemetryRecordMarshaller() {
    }

    public static TelemetryRecordMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TelemetryRecord telemetryRecord, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)telemetryRecord, (String)"telemetryRecord");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)telemetryRecord.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)telemetryRecord.segmentsReceivedCount(), SEGMENTSRECEIVEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)telemetryRecord.segmentsSentCount(), SEGMENTSSENTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)telemetryRecord.segmentsSpilloverCount(), SEGMENTSSPILLOVERCOUNT_BINDING);
            protocolMarshaller.marshall((Object)telemetryRecord.segmentsRejectedCount(), SEGMENTSREJECTEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)telemetryRecord.backendConnectionErrors(), BACKENDCONNECTIONERRORS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

