/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.Http;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HttpMarshaller {
    private static final MarshallingInfo<String> HTTPURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HttpURL").isBinary(false).build();
    private static final MarshallingInfo<Integer> HTTPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HttpStatus").isBinary(false).build();
    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HttpMethod").isBinary(false).build();
    private static final MarshallingInfo<String> USERAGENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserAgent").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientIp").isBinary(false).build();
    private static final HttpMarshaller INSTANCE = new HttpMarshaller();

    private HttpMarshaller() {
    }

    public static HttpMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Http http, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)http, (String)"http");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)http.httpURL(), HTTPURL_BINDING);
            protocolMarshaller.marshall((Object)http.httpStatus(), HTTPSTATUS_BINDING);
            protocolMarshaller.marshall((Object)http.httpMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall((Object)http.userAgent(), USERAGENT_BINDING);
            protocolMarshaller.marshall((Object)http.clientIp(), CLIENTIP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

