/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.xray.model.Edge;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EdgeMarshaller {
    private static final MarshallingInfo<Integer> REFERENCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceId").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SUMMARYSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SummaryStatistics").isBinary(false).build();
    private static final MarshallingInfo<List> RESPONSETIMEHISTOGRAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseTimeHistogram").isBinary(false).build();
    private static final MarshallingInfo<List> ALIASES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Aliases").isBinary(false).build();
    private static final EdgeMarshaller INSTANCE = new EdgeMarshaller();

    private EdgeMarshaller() {
    }

    public static EdgeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Edge edge, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)edge, (String)"edge");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)edge.referenceId(), REFERENCEID_BINDING);
            protocolMarshaller.marshall((Object)edge.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)edge.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)edge.summaryStatistics(), SUMMARYSTATISTICS_BINDING);
            protocolMarshaller.marshall(edge.responseTimeHistogram(), RESPONSETIMEHISTOGRAM_BINDING);
            protocolMarshaller.marshall(edge.aliases(), ALIASES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

