/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.xray.model.ErrorStatistics;

@SdkInternalApi
public class ErrorStatisticsMarshaller {
    private static final MarshallingInfo<Long> THROTTLECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ThrottleCount").build();
    private static final MarshallingInfo<Long> OTHERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OtherCount").build();
    private static final MarshallingInfo<Long> TOTALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalCount").build();
    private static final ErrorStatisticsMarshaller instance = new ErrorStatisticsMarshaller();

    public static ErrorStatisticsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ErrorStatistics errorStatistics, ProtocolMarshaller protocolMarshaller) {
        if (errorStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)errorStatistics.throttleCount(), THROTTLECOUNT_BINDING);
            protocolMarshaller.marshall((Object)errorStatistics.otherCount(), OTHERCOUNT_BINDING);
            protocolMarshaller.marshall((Object)errorStatistics.totalCount(), TOTALCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

